package com.bizunited.empower.business.payment.service.handle;

import com.bizunited.empower.business.payment.common.enums.ElectronicAccountType;
import com.bizunited.empower.business.payment.dto.ElectronicAccountDto;
import com.bizunited.empower.business.payment.entity.ElectronicAccount;
import com.google.common.collect.Sets;
import org.springframework.stereotype.Component;

import javax.transaction.Transactional;

import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.OPEN_ACCOUNT_FAILURE;
import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.OPEN_ACCOUNT_ING;
import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.VERIFY_FAILURE;
import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.WAIT_OPEN_ACCOUNT;
import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.WAIT_SIGN;
import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.WAIT_VERIFY;

/**
 * 待签约
 * @Author: Paul Chan
 * @Date: 2021/4/15 上午10:48
 */
@Component
public class AccountApplyWaitSignStateHandle extends AbstractAccountApplyStateHandle {
  @Override
  public int getState() {
    return WAIT_SIGN.getState();
  }

  @Override
  @Transactional
  public void handle(ElectronicAccountDto electronicAccountDto, ElectronicAccount electronicAccount) {
    if(ElectronicAccountType.INDIVIDUAL.getType().equals(electronicAccount.getType())) {
      super.validApplyState(electronicAccount.getApplyState(), electronicAccountDto.getApplyState(), Sets.newHashSet(WAIT_OPEN_ACCOUNT, OPEN_ACCOUNT_FAILURE, OPEN_ACCOUNT_ING));
      electronicAccountService.updateMerchantInfoById(electronicAccount.getId(), electronicAccountDto.getMerchantCode(), electronicAccountDto.getMerchantName(), electronicAccountDto.getBillingCycle());
    } else {
      super.validApplyState(electronicAccount.getApplyState(), electronicAccountDto.getApplyState(), Sets.newHashSet(WAIT_VERIFY, VERIFY_FAILURE));
    }
    electronicAccountService.updateApplyStateById(electronicAccount.getId(), electronicAccountDto.getApplyState(), electronicAccountDto.getLatestFailureReason());
    electronicAccountService.updateTiedCardStatusById(electronicAccount.getId(), electronicAccountDto.getTiedCardStatus());
  }
}
