package com.bizunited.empower.business.payment.service.handle;

import com.bizunited.empower.business.payment.common.enums.ElectronicAccountType;
import com.bizunited.empower.business.payment.dto.ElectronicAccountDto;
import com.bizunited.empower.business.payment.entity.ElectronicAccount;
import com.google.common.collect.Sets;
import org.springframework.stereotype.Component;

import javax.transaction.Transactional;

import java.util.Date;

import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.OPEN_ACCOUNT_FAILURE;
import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.OPEN_ACCOUNT_ING;
import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.PRE_APPLY_SUCCESS;
import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.WAIT_OPEN_ACCOUNT;
import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.WAIT_PRE_APPLY;
import static com.bizunited.empower.business.payment.common.enums.ElectronicAccountApplyState.WAIT_TIED_CARD;

/**
 * 待绑卡
 * @Author: Paul Chan
 * @Date: 2021/4/15 上午10:45
 */
@Component
public class AccountApplyWaitTiedCardStateHandle extends AbstractAccountApplyStateHandle {
  @Override
  public int getState() {
    return WAIT_TIED_CARD.getState();
  }

  @Override
  @Transactional
  public void handle(ElectronicAccountDto electronicAccountDto, ElectronicAccount electronicAccount) {
    if(ElectronicAccountType.INDIVIDUAL.getType().equals(electronicAccount.getType())) {
      super.validApplyState(electronicAccount.getApplyState(), electronicAccountDto.getApplyState(), Sets.newHashSet(WAIT_PRE_APPLY, PRE_APPLY_SUCCESS));
      electronicAccountService.updateTimesById(electronicAccount.getId(), new Date(),
          null, null, null, null);
      electronicAccountService.updateUserIdById(electronicAccount.getId(), electronicAccountDto.getUserId());
    } else {
      super.validApplyState(electronicAccount.getApplyState(), electronicAccountDto.getApplyState(), Sets.newHashSet(WAIT_OPEN_ACCOUNT, OPEN_ACCOUNT_FAILURE, OPEN_ACCOUNT_ING));
      electronicAccountService.updateMerchantInfoById(electronicAccount.getId(), electronicAccountDto.getMerchantCode(), electronicAccountDto.getMerchantName(), electronicAccountDto.getBillingCycle());
    }
    electronicAccountService.updateApplyStateById(electronicAccount.getId(), electronicAccountDto.getApplyState(), electronicAccountDto.getLatestFailureReason());
  }
}
