package com.bizunited.empower.business.payment.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.empower.business.common.service.SignService;
import com.bizunited.empower.business.common.util.ResponseModelUtils;
import com.bizunited.empower.business.payment.feign.BankCardFeignClient;
import com.bizunited.empower.business.payment.service.CustomerBankVoService;
import com.bizunited.empower.business.payment.vo.CustomerBankVo;
import com.bizunited.platform.common.controller.model.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

/**
 * andCardVo业务模型的服务层接口实现
 *
 * @author Keller
 */
@Service("CustomerBankVoServiceImpl")
public class CustomerBankVoServiceImpl implements CustomerBankVoService {
  private final static String SUCCESS_STATUS = "20";
  @Autowired
  private BankCardFeignClient bankCardFeignClient;
  @Autowired
  private SignService signService;

  @Override
  public CustomerBankVo findByCardNumner(String cardNum) {
    String appId = signService.getCurrentAppId();
    String sign = signService.sign(cardNum);
    ResponseModel responseModel = bankCardFeignClient.findByCardNumber(appId, sign, cardNum);
    ResponseModelUtils.validSuccess(responseModel);
    Object data = responseModel.getData();
    JSONObject jsonObject = (JSONObject) JSONObject.toJSON(data);
    String status = jsonObject.getString("status");
    if(StringUtils.isEmpty(status) || !SUCCESS_STATUS.equals(status)){
      throw new RuntimeException("查询卡信息错误，请重试！");
    }
    CustomerBankVo customerBankVo = new CustomerBankVo();
    customerBankVo.setBankId(jsonObject.getString("bankId"));
    customerBankVo.setCardType(jsonObject.getString("cardType"));
    customerBankVo.setBankName(jsonObject.getString("bankName"));
    return customerBankVo;
  }
}
