package com.bizunited.empower.business.payment.service.internal;

import com.bizunited.empower.business.payment.entity.CustomerCredit;
import com.bizunited.empower.business.payment.entity.CustomerCreditRecord;
import com.bizunited.empower.business.payment.repository.CustomerCreditRecordRepository;
import com.bizunited.empower.business.payment.service.CustomerCreditRecordService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.bizunited.empower.business.common.util.SecurityUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;
import java.math.BigDecimal;
import java.util.Date;

import static com.bizunited.platform.common.constant.Constants.DEFAULT_PAGEABLE;

/**
 * CustomerCreditRecord业务模型的服务层接口实现
 *
 * @author saturn
 */
@Service("CustomerCreditRecordServiceImpl")
public class CustomerCreditRecordServiceImpl implements CustomerCreditRecordService {

  @Autowired
  private CustomerCreditRecordRepository customerCreditRecordRepository;

  @Override
  @Transactional
  public CustomerCreditRecord create(CustomerCredit customerCredit, BigDecimal amount, BigDecimal beforeAmount, BigDecimal afterAmount, String remark) {
    Date now = new Date();
    String userAccount = SecurityUtils.getUserAccount();
    CustomerCreditRecord record = new CustomerCreditRecord();
    record.setCustomerCredit(customerCredit);
    record.setAmount(amount);
    record.setBeforeAmount(beforeAmount);
    record.setAfterAmount(afterAmount);
    record.setRemark(remark);
    record.setCreateTime(now);
    record.setModifyTime(now);
    record.setCreateAccount(userAccount);
    record.setModifyAccount(userAccount);
    this.createValidation(record);
    return customerCreditRecordRepository.save(record);
  }

  @Override
  public Page<CustomerCreditRecord> findByCustomerCode(Pageable pageable, String customerCode) {
    pageable = ObjectUtils.defaultIfNull(pageable, DEFAULT_PAGEABLE);
    if(StringUtils.isBlank(customerCode)) {
      return Page.empty(pageable);
    }
    String tenantCode = TenantUtils.getTenantCode();
    return customerCreditRecordRepository.findByTenantCodeAndCustomerCode(tenantCode, customerCode, pageable);
  }

  /**
   * 创建前数据校验
   * @param record
   */
  private void createValidation(CustomerCreditRecord record) {
    CustomerCredit customerCredit = record.getCustomerCredit();
    Validate.notNull(customerCredit, "客户信用信息不能为空");
    Validate.notBlank(customerCredit.getId(), "客户信用信息的主键不能为空");
    Validate.notNull(record.getAmount(), "变更信用额度金额不能为空");
    Validate.notNull(record.getBeforeAmount(), "变更前信用额度金额不能为空");
    Validate.notNull(record.getAfterAmount(), "变更后信用额度金额不能为空");
  }

}
