package com.bizunited.empower.business.payment.service.internal;

import com.bizunited.empower.business.customer.entity.Customer;
import com.bizunited.empower.business.customer.service.CustomerService;
import com.bizunited.empower.business.payment.common.enums.DefrayStatus;
import com.bizunited.empower.business.payment.common.enums.ReceiptStatus;
import com.bizunited.empower.business.payment.entity.DefrayInfo;
import com.bizunited.empower.business.payment.entity.ReceiptInfo;
import com.bizunited.empower.business.payment.repository.DefrayInfoRepository;
import com.bizunited.empower.business.payment.repository.ReceiptInfoRepository;
import com.bizunited.empower.business.payment.service.CustomerFundsVoService;
import com.bizunited.empower.business.payment.vo.CustomerFundsBillVo;
import com.bizunited.empower.business.payment.vo.CustomerFundsVo;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.bizunited.empower.business.common.util.SecurityUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

/**
 * @author Keller
 */
@Service("CustomerFundsVoServiceImpl")
public class CustomerFundsVoServiceImpl implements CustomerFundsVoService {
  /**
   * 收款类型
   */
  private final static Integer RECEIPT = 1;
  /**
   * 付款类型
   */
  private final static Integer DEFRAY = 2;
  @Autowired
  private ReceiptInfoRepository receiptInfoRepository;
  @Autowired
  private DefrayInfoRepository defrayInfoRepository;
  @Autowired
  private CustomerService customerService;

  @Override
  public CustomerFundsVo findByTimes(String startTime, String endTime, Integer type) {
    Validate.notNull(startTime, "开始时间不能为空，请检查！");
    Validate.notNull(endTime, "结束时间不能为空，请检查！");
    Validate.notNull(type, "查询类型不能为空，请检查！");
    String customerCode = SecurityUtils.getUserAccount();
    // 临时修复移小程序端存储手机号的问题，待RBAC模块统一调整后优化
    if(!customerCode.startsWith("KH")){
      Customer customer = customerService.findByPhoneAntTenantCode(customerCode);
      customerCode = customer.getCustomerCode();
    }
    Date startTimeDate = null;
    Date endTimeDate = null;
    try {
      startTimeDate = DateUtils.parseDate(startTime,"yyyy-MM-dd HH:mm:ss");
      endTimeDate = DateUtils.parseDate(endTime,"yyyy-MM-dd HH:mm:ss");
    } catch (ParseException e) {
      throw new IllegalArgumentException("日期格式转换失败");
    }
    List<ReceiptInfo> receiptInfos = receiptInfoRepository.findByCustomerCodeAndTstatusAndTimesAndTenantCode(customerCode, ReceiptStatus.CONFIRMED.getValue(), startTimeDate, endTimeDate, TenantUtils.getTenantCode());
    List<DefrayInfo> defrayInfos = defrayInfoRepository.findByCustomerCodeAndTstatusAndTimesAndTenantCode(customerCode, DefrayStatus.CONFIRMED.getValue(), startTimeDate, endTimeDate, TenantUtils.getTenantCode());
    // 参数初始化
    BigDecimal defrayAmount = BigDecimal.ZERO.setScale(4);
    BigDecimal receiptAmount = BigDecimal.ZERO.setScale(4);

    CustomerFundsVo customerFundsVo = new CustomerFundsVo();
    List<CustomerFundsBillVo> customerFundsBillVos = Lists.newArrayList();
    if (!CollectionUtils.isEmpty(receiptInfos)) {
      for(ReceiptInfo item :receiptInfos){
        CustomerFundsBillVo customerFundsBillVo = new CustomerFundsBillVo();
        customerFundsBillVo.setAmount(item.getReceiptAmount());
        customerFundsBillVo.setCreateTime(item.getCreateTime());
        customerFundsBillVo.setAssociatedCode(item.getReceivableInfo().getAssociatedCode());
        customerFundsBillVo.setType(RECEIPT);
        customerFundsBillVo.setBusinessType(item.getReceivableInfo().getReceivableType());
        customerFundsBillVo.setFundsChannel(item.getFundsChannel());
        receiptAmount = receiptAmount.add(item.getReceiptAmount());
        if(type != 2) {
          customerFundsBillVos.add(customerFundsBillVo);
        }
      }
    }
    if (!CollectionUtils.isEmpty(defrayInfos)) {
      for(DefrayInfo item:defrayInfos){
        CustomerFundsBillVo customerFundsBillVo = new CustomerFundsBillVo();
        customerFundsBillVo.setAmount(item.getDefrayAmount());
        customerFundsBillVo.setCreateTime(item.getCreateTime());
        customerFundsBillVo.setAssociatedCode(item.getPaymentInfo().getAssociatedCode());
        customerFundsBillVo.setType(DEFRAY);
        customerFundsBillVo.setBusinessType(item.getPaymentInfo().getPayType());
        customerFundsBillVo.setFundsChannel(item.getFundsChannel());
        defrayAmount = defrayAmount.add(item.getDefrayAmount());
        if(type != 3) {
          customerFundsBillVos.add(customerFundsBillVo);
        }
      }
    }
    // 排序
    customerFundsBillVos.sort(Comparator.comparing(CustomerFundsBillVo::getCreateTime));
    customerFundsVo.setCustomerFundsBillVos(customerFundsBillVos);
    customerFundsVo.setDefrayAmount(defrayAmount);
    customerFundsVo.setReceiptAmount(receiptAmount);
    customerFundsVo.setCustomerCode(customerCode);
    return customerFundsVo;
  }
}