package com.bizunited.empower.business.payment.service.internal;

import com.bizunited.empower.business.common.util.DateUtils;
import com.bizunited.empower.business.payment.common.enums.CustomerWalletBillType;
import com.bizunited.empower.business.payment.service.CustomerWalletBillService;
import com.bizunited.empower.business.payment.service.CustomerWalletService;
import com.bizunited.empower.business.payment.service.CustomerWalletStatisticsVoService;
import com.bizunited.empower.business.payment.vo.CustomerWalletStatisticsVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 客户电子钱包统计服务
 * @Author: Paul Chan
 * @Date: 2021/4/13 下午6:28
 */
@Service
public class CustomerWalletStatisticsVoServiceImpl implements CustomerWalletStatisticsVoService {

  @Autowired
  private CustomerWalletService customerWalletService;
  @Autowired
  private CustomerWalletBillService customerWalletBillService;

  @Override
  public CustomerWalletStatisticsVo findByTenant() {
    Date start = DateUtils.getYesterdayStartDate();
    Date end = DateUtils.getYesterdayEndDate();
    BigDecimal totalBalance = customerWalletService.sumBalance();
    BigDecimal yesterdayReceiptAmount = customerWalletBillService.sumAmountByTypeAndTimeBetween(CustomerWalletBillType.RECEIPT.getType(), start, end);
    BigDecimal yesterdayRecoverAmount = customerWalletBillService.sumAmountByTypeAndTimeBetween(CustomerWalletBillType.RECOVER.getType(), start, end);
    CustomerWalletStatisticsVo vo = new CustomerWalletStatisticsVo();
    vo.setTotalBalance(totalBalance);
    vo.setYesterdayReceiptAmount(yesterdayReceiptAmount.abs());
    vo.setYesterdayRecoverAmount(yesterdayRecoverAmount);
    return vo;
  }


}
