package com.bizunited.empower.business.payment.service.internal;

import com.bizunited.empower.business.payment.entity.DefrayAttachment;
import com.bizunited.empower.business.payment.repository.DefrayAttachmentRepository;
import com.bizunited.empower.business.payment.service.DefrayAttachmentService;
import com.bizunited.empower.business.common.util.SecurityUtils;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;
import java.util.Date;
import java.util.Optional;
import java.util.Set;

/**
 * ReceiptFile业务模型的服务层接口实现
 * @author saturn
 */
@Service("DefrayAttachmentServiceImpl")
public class DefrayAttachmentServiceImpl implements DefrayAttachmentService {
  @Autowired
  private DefrayAttachmentRepository defrayAttachmentRepository;
  @Transactional
  @Override
  public DefrayAttachment create(DefrayAttachment defrayAttachment) {
    DefrayAttachment current = this.createForm(defrayAttachment);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  } 
  @Transactional
  @Override
  public DefrayAttachment createForm(DefrayAttachment defrayAttachment) {
   /* 
    * 针对1.1.3版本的需求，这个对静态模型的保存操作做出调整，新的包裹过程为：
    * 1、如果当前模型对象不是主模型
    * 1.1、那么创建前只会验证基本信息，直接的ManyToOne关联（单选）和ManyToMany关联（多选）
    * 1.2、验证完成后，也只会保存当前对象的基本信息，直接的单选
    * 2、如果当前模型对象是主业务模型
    *  2.1、创建前会验证当前模型的基本属性，单选和多选属性
    *  2.2、然后还会验证当前模型关联的各个OneToMany明细信息，调用明细对象的服务，明每一条既有明细进行验证
    *  （2.2的步骤还需要注意，如果当前被验证的关联对象是回溯对象，则不需要验证了）
    * 2.3、还会验证当前模型关联的各个OneToOne分组，调用分组对象的服务，对分组中的信息进行验证
    *   2.3.1、包括验证每一个分组项的基本信息、直接的单选、多选信息
    *   2.3.2、以及验证每个分组的OneToMany明细信息
    * */
    Date now = new Date();
    defrayAttachment.setCreateAccount(SecurityUtils.getUserAccount());
    defrayAttachment.setCreateTime(now);
    defrayAttachment.setModifyAccount(SecurityUtils.getUserAccount());
    defrayAttachment.setModifyTime(now);

    this.createValidation(defrayAttachment);
    
    // ===============================
    //  和业务有关的验证填写在这个区域    
    // ===============================
    
    this.defrayAttachmentRepository.save(defrayAttachment);
    
    // 返回最终处理的结果，里面带有详细的关联信息
    return defrayAttachment;
  }
  /**
   * 在创建一个新的DefrayAttachment模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   */
  private void createValidation(DefrayAttachment defrayAttachment) {
    Validate.notNull(defrayAttachment, "进行当前操作时，信息对象必须传入!!");
    // 判定那些不能为null的输入值：条件为 caninsert = true，且nullable = false
    Validate.isTrue(StringUtils.isBlank(defrayAttachment.getId()), "添加信息时，当期信息的数据编号（主键）不能有值！");
    defrayAttachment.setId(null);
    Validate.notBlank(defrayAttachment.getRelativePath(), "添加信息时，相对路径不能为空！");
    Validate.notBlank(defrayAttachment.getFileName(), "添加信息时，原始文件名不能为空！");
    Validate.notBlank(defrayAttachment.getReFileName(), "添加信息时，重命名后的文件名不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK （注意连续空字符串的情况） 
    Validate.isTrue(defrayAttachment.getRelativePath() == null || defrayAttachment.getRelativePath().length() < 255 , "相对路径,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(defrayAttachment.getFileName() == null || defrayAttachment.getFileName().length() < 128 , "原始文件名,在进行添加时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(defrayAttachment.getReFileName() == null || defrayAttachment.getReFileName().length() < 128 , "重命名后的文件名,在进行添加时填入值超过了限定长度(128)，请检查!");
  }
  @Transactional
  @Override
  public DefrayAttachment update(DefrayAttachment defrayAttachment) {
    DefrayAttachment current = this.updateForm(defrayAttachment);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  } 
  @Transactional
  @Override
  public DefrayAttachment updateForm(DefrayAttachment defrayAttachment) {
    /* 
     * 针对1.1.3版本的需求，这个对静态模型的修改操作做出调整，新的过程为：
     * 1、如果当前模型对象不是主模型
     * 1.1、那么创建前只会验证基本信息，直接的ManyToOne关联（单选）和ManyToMany关联（多选）
     * 1.2、验证完成后，也只会保存当前对象的基本信息，直接的单选
     * 2、如果当前模型对象是主业务模型
     *  2.1、创建前会验证当前模型的基本属性，单选和多选属性
     *  2.2、然后还会验证当前模型关联的各个OneToMany明细信息，调用明细对象的服务，明每一条既有明细进行验证
     *  （2.2的步骤还需要注意，如果当前被验证的关联对象是回溯对象，则不需要验证了）
     *  2.3、还会验证当前模型关联的各个OneToOne分组，调用分组对象的服务，对分组中的信息进行验证
     *    2.3.1、包括验证每一个分组项的基本信息、直接的单选、多选信息
     *    2.3.2、以及验证每个分组的OneToMany明细信息
     * */
    
    this.updateValidation(defrayAttachment);
    // ===================基本信息
    String currentId = defrayAttachment.getId();
    Optional<DefrayAttachment> op_currentReceiptFile = this.defrayAttachmentRepository.findById(currentId);
    DefrayAttachment currentDefrayAttachment = op_currentReceiptFile.orElse(null);
    Validate.notNull(currentDefrayAttachment,"未发现指定的原始模型对象信");
    // 开始赋值——更新时间与更新人
    Date now = new Date();
    currentDefrayAttachment.setModifyAccount(SecurityUtils.getUserAccount());
    currentDefrayAttachment.setModifyTime(now);
    // 开始重新赋值——一般属性
    currentDefrayAttachment.setRelativePath(currentDefrayAttachment.getRelativePath());
    currentDefrayAttachment.setFileName(currentDefrayAttachment.getFileName());
    currentDefrayAttachment.setReFileName(currentDefrayAttachment.getReFileName());
    currentDefrayAttachment.setDefrayInfo(currentDefrayAttachment.getDefrayInfo());
    
    this.defrayAttachmentRepository.saveAndFlush(currentDefrayAttachment);
    return currentDefrayAttachment;
  }
  /**
   * 在更新一个已有的ReceiptFile模型对象之前，该私有方法检查对象各属性的正确性，其id属性必须有值
   */
  private void updateValidation(DefrayAttachment defrayAttachment) {
    Validate.isTrue(!StringUtils.isBlank(defrayAttachment.getId()), "修改信息时，当期信息的数据编号（主键）必须有值！");
    
    // 基础信息判断，基本属性，需要满足not null
    Validate.notBlank(defrayAttachment.getRelativePath(), "修改信息时，相对路径不能为空！");
    Validate.notBlank(defrayAttachment.getFileName(), "修改信息时，原始文件名不能为空！");
    Validate.notBlank(defrayAttachment.getReFileName(), "修改信息时，重命名后的文件名不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK，且canupdate = true
    Validate.isTrue(defrayAttachment.getRelativePath() == null || defrayAttachment.getRelativePath().length() < 255 , "相对路径,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(defrayAttachment.getFileName() == null || defrayAttachment.getFileName().length() < 128 , "原始文件名,在进行修改时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(defrayAttachment.getReFileName() == null || defrayAttachment.getReFileName().length() < 128 , "重命名后的文件名,在进行修改时填入值超过了限定长度(128)，请检查!");
    
    // 关联性判断，关联属性判断，需要满足ManyToOne或者OneToOne，且not null 且是主模型
  } 
  @Override
  public Set<DefrayAttachment> findDetailsByDefrayInfo(String defrayInfo) {
    if(StringUtils.isBlank(defrayInfo)) {
      return Sets.newHashSet();
    }
    return this.defrayAttachmentRepository.findDetailsByDefrayInfo(defrayInfo);
  }
  @Override
  public DefrayAttachment findDetailsById(String id) {
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    return this.defrayAttachmentRepository.findDetailsById(id);
  }
  @Override
  public DefrayAttachment findById(String id) {
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    
    Optional<DefrayAttachment> op = defrayAttachmentRepository.findById(id);
    return op.orElse(null); 
  }
  @Override
  @Transactional
  public void deleteById(String id) {
    // 只有存在才进行删除
    Validate.notBlank(id , "进行删除时，必须给定主键信息!!");
    DefrayAttachment current = this.findById(id);
    if(current != null) { 
      this.defrayAttachmentRepository.delete(current);
    }
  }
} 
