package com.bizunited.empower.business.payment.service.internal;

import com.bizunited.empower.business.payment.entity.ElectronicAccount;
import com.bizunited.empower.business.payment.entity.ElectronicAccountFailureRecord;
import com.bizunited.empower.business.payment.repository.ElectronicAccountFailureRecordRepository;
import com.bizunited.empower.business.payment.service.ElectronicAccountFailureRecordService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;
import java.util.Date;
import java.util.List;

/**
 * 电子账户申请失败服务实现
 * @Author: Paul Chan
 * @Date: 2021/4/9 上午11:21
 */
@Service
public class ElectronicAccountFailureRecordServiceImpl implements ElectronicAccountFailureRecordService {

  @Autowired
  private ElectronicAccountFailureRecordRepository electronicAccountFailureRecordRepository;

  @Override
  @Transactional
  public ElectronicAccountFailureRecord create(ElectronicAccountFailureRecord record) {
    this.createValidation(record);
    record.setCreateTime(new Date());
    return electronicAccountFailureRecordRepository.save(record);
  }

  @Override
  @Transactional
  public ElectronicAccountFailureRecord create(String accountId, String failureReason) {
    Validate.notBlank(accountId, "电子账户ID不能为空");
    ElectronicAccountFailureRecord record = new ElectronicAccountFailureRecord();
    ElectronicAccount account = new ElectronicAccount();
    account.setId(accountId);
    record.setElectronicAccount(account);
    record.setFailureReason(failureReason);
    return this.create(record);
  }

  @Override
  public List<ElectronicAccountFailureRecord> findByElectronicAccountId(String electronicAccountId) {
    if(StringUtils.isBlank(electronicAccountId)) {
      return Lists.newArrayList();
    }
    return electronicAccountFailureRecordRepository.findByElectronicAccountId(electronicAccountId);
  }

  /**
   * 创建前边界校验
   * @param record
   */
  private void createValidation(ElectronicAccountFailureRecord record) {
    Validate.notNull(record, "创建对象不能为空");
    Validate.notNull(record.getElectronicAccount(), "电子账户对象不能为空");
    Validate.notBlank(record.getElectronicAccount().getId(), "电子账户对象主键不能为空");
  }

}
