package com.bizunited.empower.business.payment.service.internal;

import com.bizunited.empower.business.common.service.SignService;
import com.bizunited.empower.business.common.util.ResponseModelUtils;
import com.bizunited.empower.business.payment.feign.ElectronicAccountRateFeignClient;
import com.bizunited.empower.business.payment.service.ElectronicAccountRateVoService;
import com.bizunited.empower.business.payment.vo.ElectronicAccountRateVo;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 电子账户的费率服务
 * @Author: Paul Chan
 * @Date: 2021/4/27 下午2:24
 */
@Service
public class ElectronicAccountRateVoServiceImpl implements ElectronicAccountRateVoService {

  @Autowired
  private ElectronicAccountRateFeignClient electronicAccountRateFeignClient;

  @Autowired
  private SignService signService;

  @Override
  public List<ElectronicAccountRateVo> findByTenant() {
    String tenantCode = TenantUtils.getTenantCode();
    String appId = signService.getCurrentAppId();
    String sign = signService.sign(tenantCode);
    ResponseModel response = electronicAccountRateFeignClient.findByTenantCodeForSign(appId, sign, tenantCode);
    return ResponseModelUtils.getList(response, new TypeReference<List<ElectronicAccountRateVo>>() {});
  }

}
