package com.bizunited.empower.business.payment.service.internal;

import com.bizunited.empower.business.common.util.DateUtils;
import com.bizunited.empower.business.payment.common.enums.ElAccountBillType;
import com.bizunited.empower.business.payment.entity.ElectronicAccount;
import com.bizunited.empower.business.payment.service.ElectronicAccountBillService;
import com.bizunited.empower.business.payment.service.ElectronicAccountService;
import com.bizunited.empower.business.payment.service.ElectronicAccountStatisticsVoService;
import com.bizunited.empower.business.payment.vo.ElectronicAccountStatisticsVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 电子账户统计服务
 * @Author: Paul Chan
 * @Date: 2021/4/21 上午11:38
 */
@Service
public class ElectronicAccountStatisticsVoServiceImpl implements ElectronicAccountStatisticsVoService {

  @Autowired
  private ElectronicAccountService electronicAccountService;
  @Autowired
  private ElectronicAccountBillService electronicAccountBillService;


  @Override
  public ElectronicAccountStatisticsVo findByTenant() {
    Date startDate = DateUtils.getYesterdayStartDate();
    Date endDate = DateUtils.getYesterdayEndDate();
    ElectronicAccountStatisticsVo statisticsVo = new ElectronicAccountStatisticsVo();
    ElectronicAccount account = electronicAccountService.findDetailsByTenant();
    BigDecimal yesterdayReceiptAmount = electronicAccountBillService.sumRealAmountByTypeAndModifyTimeBetween(ElAccountBillType.RECEIPT.getType(), startDate, endDate);
    BigDecimal yesterdayPaymentAmount = electronicAccountBillService.sumRealAmountByTypeAndModifyTimeBetween(ElAccountBillType.PAYMENT.getType(), startDate, endDate);
    statisticsVo.setBalance(BigDecimal.ZERO);
    if(account != null) {
      statisticsVo.setBalance(account.getBalance());
    }
    statisticsVo.setYesterdayReceiptAmount(yesterdayReceiptAmount);
    statisticsVo.setYesterdayPaymentAmount(yesterdayPaymentAmount);
    return statisticsVo;
  }

  @Override
  public ElectronicAccountStatisticsVo findByAccountId(String accountId) {
    Date startDate = DateUtils.getYesterdayStartDate();
    Date endDate = DateUtils.getYesterdayEndDate();
    ElectronicAccount account = electronicAccountService.findById(accountId);
    ElectronicAccountStatisticsVo statisticsVo = new ElectronicAccountStatisticsVo();
    BigDecimal yesterdayReceiptAmount = electronicAccountBillService.sumRealAmountByAccountIdAndTypeAndModifyTimeBetween(accountId, ElAccountBillType.RECEIPT.getType(), startDate, endDate);
    BigDecimal yesterdayPaymentAmount = electronicAccountBillService.sumRealAmountByAccountIdAndTypeAndModifyTimeBetween(accountId, ElAccountBillType.PAYMENT.getType(), startDate, endDate);
    statisticsVo.setBalance(BigDecimal.ZERO);
    if(account != null) {
      statisticsVo.setBalance(account.getBalance());
    }
    statisticsVo.setYesterdayReceiptAmount(yesterdayReceiptAmount);
    statisticsVo.setYesterdayPaymentAmount(yesterdayPaymentAmount);
    return statisticsVo;
  }

}
