package com.bizunited.empower.business.payment.service.internal;

import com.bizunited.empower.business.common.service.SignService;
import com.bizunited.empower.business.common.util.ResponseModelUtils;
import com.bizunited.empower.business.payment.dto.ExtractCashDto;
import com.bizunited.empower.business.payment.entity.ElectronicAccount;
import com.bizunited.empower.business.payment.feign.ExtractCashFeignClient;
import com.bizunited.empower.business.payment.service.ExtractCashDtoService;
import com.bizunited.empower.business.payment.vo.ExtractCashVo;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.util.JsonUtils;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * 提现统一入口服务
 * @Author: Paul Chan
 * @Date: 2021/4/28 下午2:09
 */
@Service
public class ExtractCashDtoServiceImpl implements ExtractCashDtoService {

  @Autowired
  private ExtractCashFeignClient extractCashFeignClient;

  @Autowired
  private SignService signService;

  @Override
  public ExtractCashVo extractCash(ElectronicAccount account, BigDecimal amount) {
    Validate.notNull(account, "电子账户信息不能为空");
    Validate.notNull(amount, "提现金额不能为空");
    Validate.isTrue(amount.compareTo(BigDecimal.ZERO) > 0, "提现金额必须大于0");
    Validate.isTrue(amount.setScale(2, BigDecimal.ROUND_HALF_UP).compareTo(amount) == 0, "提现金额只支持两位小数");
    BigDecimal fenAmount = amount.multiply(BigDecimal.valueOf(100)).setScale(0, BigDecimal.ROUND_HALF_UP);
    String tenantCode = TenantUtils.getTenantCode();
    ExtractCashDto dto = new ExtractCashDto();
    dto.setAmount(fenAmount.toString());
    dto.setArrivalType("10");
    dto.setTenantCode(tenantCode);
    dto.setUserType(3);
    String json = JsonUtils.obj2JsonString(dto);
    String appId = signService.getCurrentAppId();
    String sign = signService.sign(json);
    ResponseModel responseModel = extractCashFeignClient.extractCash(appId, sign, json);
    boolean result = ResponseModelUtils.isSuccess(responseModel);
    if(!result){
      throw new RuntimeException(responseModel.getMessage());
    }
    ExtractCashVo extractCashVo = ResponseModelUtils.getSuccessData(responseModel, ExtractCashVo.class);
    Validate.notNull(extractCashVo, "调用运营平台接口返回数据为空");
    Validate.isTrue(!"3".equals(extractCashVo.getStatus()), "提现失败");
    return extractCashVo;
  }
}
