package com.bizunited.empower.business.payment.service.internal;

import com.bizunited.empower.business.payment.repository.PaymentInfoRepository;
import com.bizunited.empower.business.payment.service.PaymentDashBoardVoService;
import com.bizunited.empower.business.payment.vo.PaymentDashBoardVo;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Map;

/**
 * ReceivableDashBoardVo业务模型的服务层接口实现
 *
 * @author Keller
 */
@Service("PaymentDashBoardVoServiceImpl")
public class PaymentDashBoardVoServiceImpl implements PaymentDashBoardVoService {
  @Autowired
  private PaymentInfoRepository paymentInfoRepository;

  @Override
  public PaymentDashBoardVo statistics() {
    Map<String, Object> data = paymentInfoRepository.statistics(TenantUtils.getTenantCode());
    if (data != null) {
      PaymentDashBoardVo paymentDashBoardVo = new PaymentDashBoardVo();
      paymentDashBoardVo.setPaymentAmount((BigDecimal) data.get("payAmount"));
      paymentDashBoardVo.setWaitPayAmount((BigDecimal) data.get("waitPayAmount"));
      paymentDashBoardVo.setWaitConfirmAmount((BigDecimal) data.get("waitConfirmAmount"));
      paymentDashBoardVo.setPayedAmount((BigDecimal) data.get("payedAmount"));
      return paymentDashBoardVo;
    }
    return null;
  }
}
