package com.bizunited.empower.business.payment.service.internal;

import com.bizunited.empower.business.payment.repository.ReceivableInfoRepository;
import com.bizunited.empower.business.payment.service.ReceivableDashBoardVoService;
import com.bizunited.empower.business.payment.vo.ReceivableDashBoardVo;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Map;

/**
 * ReceivableDashBoardVo业务模型的服务层接口实现
 *
 * @author Keller
 */
@Service("ReceivableDashBoardVoServiceImpl")
public class ReceivableDashBoardVoServiceImpl implements ReceivableDashBoardVoService {
  @Autowired
  private ReceivableInfoRepository receivableInfoRepository;

  @Override
  public ReceivableDashBoardVo statistics() {
    Map<String , Object> data = receivableInfoRepository.statistics(TenantUtils.getTenantCode());
    if (data != null) {
      ReceivableDashBoardVo receivableDashBoardVo = new ReceivableDashBoardVo();
      receivableDashBoardVo.setReceivableAmount((BigDecimal) data.get("receivableAmount"));
      receivableDashBoardVo.setWaitReceiveAmount((BigDecimal) data.get("waitReceiveAmount"));
      receivableDashBoardVo.setWaitConfirmAmount((BigDecimal) data.get("waitConfirmAmount"));
      receivableDashBoardVo.setReceivedAmount((BigDecimal) data.get("receivedAmount"));
      return receivableDashBoardVo;
    }
    return null;
  }
}
