package com.bizunited.empower.business.payment.service.listener;

import com.bizunited.empower.business.payment.configuration.RabbitmqConfig;
import com.bizunited.empower.business.payment.dto.RefundNoticeDto;
import com.bizunited.platform.common.util.JsonUtils;
import com.bizunited.platform.common.util.tenant.TenantContextHolder;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.stereotype.Component;

import java.nio.charset.StandardCharsets;

/**
 * 退款事件变动消息监听
 *
 * @author Keller
 */
@Component
@ConditionalOnBean(RabbitmqConfig.class)
@RabbitListener(queues = "${operate.bucketCode:}_refund.queue")
public class RefundEventListener {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(RefundEventListener.class);

  @Value("${operate.bucketCode:}")
  private String bucketCode;
  /**
   * 成功状态
   */
  public static final int SUCCESS = 2;

  @RabbitHandler
  public void process(byte[] contents) {
    if(ArrayUtils.isEmpty(contents)) {
      return;
    }
    String content = new String(contents, StandardCharsets.UTF_8);
    LOGGER.debug("退款通知收到内容:{}",content);
    RefundNoticeDto refundNoticeDto;
    try {
      refundNoticeDto = JsonUtils.json2Obj(content, RefundNoticeDto.class);
      if(!bucketCode.equals(refundNoticeDto.getBucketCode())) {
        return;
      }
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      throw new RuntimeException("json解析错误", e);
    }
    Validate.notBlank(refundNoticeDto.getAppCode(), "appCode不能为空");
    Validate.notBlank(refundNoticeDto.getTenantCode(), "tenantCode不能为空");
    try {
      TenantContextHolder.setApp(refundNoticeDto.getAppCode());
      TenantContextHolder.setTenant(refundNoticeDto.getTenantCode());
      if(SUCCESS == refundNoticeDto.getStatus()){
        // TODO 需要和支付是针对收款单，退款也只有针对收款单
      }
    } finally {
      TenantContextHolder.clean();
    }
  }
}
