package com.bizunited.empower.business.payment.service.notifier;

import com.bizunited.empower.business.customer.service.notifier.CustomerEventListener;
import com.bizunited.empower.business.customer.vo.CustomerCategoryVo;
import com.bizunited.empower.business.customer.vo.CustomerLevelVo;
import com.bizunited.empower.business.customer.vo.CustomerVo;
import com.bizunited.empower.business.customer.vo.SalesAreaVo;
import com.bizunited.empower.business.payment.service.CustomerWalletService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 实现客户事件监听
 * @Author: Paul Chan
 * @Date: 2021/4/16 下午2:24
 */
@Component
public class PaymentCustomerEventListener implements CustomerEventListener {

  @Autowired
  private CustomerWalletService customerWalletService;

  @Override
  public void onCreated(CustomerVo customer) {
    Validate.notNull(customer, "客户不能为空");
    Validate.notBlank(customer.getCustomerCode(), "客户编码不能为空");
    customerWalletService.init(customer.getCustomerCode());
  }

  @Override
  public void onUpdated(CustomerVo customer) {

  }

  @Override
  public void onDisabled(CustomerVo customer) {

  }

  @Override
  public void onEnabled(CustomerVo customer) {

  }

  @Override
  public void onLevelChanged(CustomerVo customer, CustomerLevelVo before, CustomerLevelVo after) {

  }

  @Override
  public void onCategoryChanged(CustomerVo customer, CustomerCategoryVo before, CustomerCategoryVo after) {

  }

  @Override
  public void onSalesAreaChanged(CustomerVo customer, SalesAreaVo before, SalesAreaVo after) {

  }
}
