package com.bizunited.empower.business.payment.service.notifier;

import com.bizunited.empower.business.payment.entity.DefrayInfo;
import com.bizunited.empower.business.payment.entity.PaymentInfo;

/**
 * 支付事件发生时，该监听器中的事件被触发。</br>
 * 主要相关的事件包括，首次支付、部分支付
 *
 * @author yinwenjie
 */
public interface PaymentEventListener {
  /**
   * 只要付款发生并且成功，无论是什么样的付款方式，该方法都会被触发。
   *
   * @param paymentInfo 当次付款对应的
   * @param defrayInfo  当次成功付款的付款单。
   */
  void onDefray(PaymentInfo paymentInfo, DefrayInfo defrayInfo);

  /**
   * 只有付款单完成了所有应付金额的支付，该事件才会被触发。
   *
   * @param paymentInfo
   */
  void onPaymentComplete(PaymentInfo paymentInfo);

  /**
   * 当指定的收款单已被成功取消后，该事件被触发
   *
   * @param paymentInfo
   */
  void onPaymentCancelled(PaymentInfo paymentInfo);
}