package com.bizunited.empower.business.payment.service.notifier;

import com.bizunited.empower.business.payment.entity.ReceiptInfo;
import com.bizunited.empower.business.payment.entity.ReceivableInfo;

/**
 * 应收账款监听器,收款事件发生时，该监听器中的事件被触发。<br/>
 * 主要相关的事件包括，首次收款、部分收款，取消收款
 *
 * @author Keller
 */
public interface ReceivableEventListener {

  /**
   * 只要收款发生并且成功，无论是什么样的付款方式，该方法都会被触发。
   * @param receivableInfo 当前的应收账款信息
   * @param receiptInfo 当次收款行为的收款单信息
   */
  void onReceipt(ReceivableInfo receivableInfo , ReceiptInfo receiptInfo);

  /**
   * 只有付款单完成了所有应付金额的支付，该事件才会被触发。
   * @param receivableInfo
   */
  void onReceivableComplete(ReceivableInfo receivableInfo);

  /**
   * 当指定的收款单已被成功取消后，该事件被触发
   * @param receivableInfo
   */
  void onReceivableCancelled(ReceivableInfo receivableInfo);
}
