package com.bizunited.empower.business.payment.service.notifier;

import com.bizunited.empower.business.payment.entity.SupplierPaymentInfo;

/**
 * 供应商付款单完成事件
 *
 * @author Keller
 */
public interface SupplierPaymentEventListener {
  /**
   * 只有采购应付账款单完成了所有应付金额的支付，该事件才会被触发。
   *
   * @param supplierPaymentInfo
   */
  void onPaymentComplete(SupplierPaymentInfo supplierPaymentInfo);

  /**
   * 当指定的采购应付账款已被成功取消后，该事件被触发
   *
   * @param supplierPaymentInfo
   */
  void onPaymentCancelled(SupplierPaymentInfo supplierPaymentInfo);
}
