package com.bizunited.empower.business.payment.service.notifier;

import com.bizunited.empower.business.payment.entity.SupplierReceivableInfo;

/**
 * 供应商应收账款单完成事件
 *
 * @author Keller
 */
public interface SupplierReceivableEventListener {
  /**
   * 只有采购应收账款款单完成了所有应付金额的支付，该事件才会被触发。
   *
   * @param supplierReceivableInfo
   */
  void onReceivableComplete(SupplierReceivableInfo supplierReceivableInfo);

  /**
   * 当指定的采购应收账款已被成功取消后，该事件被触发
   *
   * @param supplierReceivableInfo
   */
  void onReceivableCancelled(SupplierReceivableInfo supplierReceivableInfo);
}
