package com.bizunited.empower.business.payment.service.strategy;

import com.bizunited.empower.business.payment.common.enums.DefrayStatus;
import com.bizunited.empower.business.payment.common.enums.FundsChannelType;
import com.bizunited.empower.business.payment.entity.DefrayInfo;
import com.bizunited.empower.business.payment.repository.DefrayInfoRepository;
import com.bizunited.empower.business.payment.service.DefrayStrategy;
import com.bizunited.empower.business.payment.service.PaymentInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;

/**
 * 余额应付单
 *
 * @author Keller
 */
@Service
public class BalanceDefrayStrategy implements DefrayStrategy {
  @Autowired
  private DefrayInfoRepository defrayInfoRepository;
  @Autowired
  private PaymentInfoService paymentInfoService;

  @Override
  public Integer getFundsChannel() {
    return FundsChannelType.BALANCE.getValue();
  }

  @Override
  @Transactional
  public void handler(DefrayInfo defrayInfo) {
    /*
     * 余额应付单
     * 1、直接添加余额
     */
    defrayInfo.setDefrayStatus(DefrayStatus.CONFIRMED.getValue());
    defrayInfo = this.defrayInfoRepository.saveAndFlush(defrayInfo);
    this.paymentInfoService.give(defrayInfo.getPaymentInfo().getPaymentCode(), defrayInfo.getDefrayAmount(), defrayInfo);
  }
}
