package com.bizunited.empower.business.payment.service.strategy;

import com.bizunited.empower.business.payment.common.enums.FundsChannelType;
import com.bizunited.empower.business.payment.entity.ReceiptInfo;
import com.bizunited.empower.business.payment.service.ReceiptCancelStrategy;
import com.bizunited.platform.common.service.invoke.InvokeParams;
import org.springframework.stereotype.Service;

/**
 * 余额支付取消策略
 *
 * @author Keller
 */
@Service
public class BalancePayCancelStrategy implements ReceiptCancelStrategy {

  @Override
  public Integer getFundsChannel() {
    return FundsChannelType.BALANCE.getValue();
  }

  @Override
  public InvokeParams handler(ReceiptInfo receiptInfo, InvokeParams params) {
    /*
     * 1、余额支付没有确认状态
     * 2、异常情况
     */
    throw new RuntimeException(String.format("余额支付无法取消，请检查收款单号：【%s】信息！", receiptInfo.getReceiptCode()));
  }
}
