package com.bizunited.empower.business.payment.service.strategy;

import com.bizunited.empower.business.customer.common.enums.CustomerSmsBusinessType;
import com.bizunited.empower.business.customer.service.CustomerSmsService;
import com.bizunited.empower.business.payment.common.enums.FundsChannelType;
import com.bizunited.empower.business.payment.common.enums.ReceiptStatus;
import com.bizunited.empower.business.payment.entity.ReceiptInfo;
import com.bizunited.empower.business.payment.repository.ReceiptInfoRepository;
import com.bizunited.empower.business.payment.service.ReceiptStrategy;
import com.bizunited.empower.business.payment.service.ReceivableInfoService;
import com.bizunited.platform.common.service.invoke.InvokeParams;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;

/**
 * 余额支付策略
 *
 * @author Keller
 */
@Service
public class BalancePayStrategy implements ReceiptStrategy {
  @Autowired
  private ReceiptInfoRepository receiptInfoRepository;
  @Autowired
  private ReceivableInfoService receivableInfoService;
  @Autowired
  private CustomerSmsService customerSmsService;

  @Override
  public Integer getFundsChannel() {
    return FundsChannelType.BALANCE.getValue();
  }

  @Override
  @Transactional
  public InvokeParams handler(ReceiptInfo receiptInfo, InvokeParams params) {
    /*
     * 1、验证是否内部请求余额支付
     * 2、非内部请求余额支付验证短信验证码
     * 3、余额支付金额验证
     * 4、调用余额支付的接口
     */
    boolean isInternal = BooleanUtils.isTrue((Boolean) params.getInvokeParam("_internal"));
    if(!isInternal) {
      String validCode = (String) params.getInvokeParam("validCode");
      Validate.notBlank(validCode, "验证码为空，请重试！");
      customerSmsService.verifyValidCode(receiptInfo.getCustomerCode(), null, CustomerSmsBusinessType.ORDER_RECEIPT, validCode, null);
    }
    receiptInfo.setReceiptStatus(ReceiptStatus.CONFIRMED.getValue());
    receiptInfo = this.receiptInfoRepository.saveAndFlush(receiptInfo);
    this.receivableInfoService.receive(receiptInfo.getReceivableInfo().getReceivableCode(), receiptInfo.getReceiptAmount(), receiptInfo);
    return params;
  }
}
