package com.bizunited.empower.business.payment.service.strategy;

import com.bizunited.empower.business.payment.common.enums.DefrayStatus;
import com.bizunited.empower.business.payment.common.enums.FundsChannelType;
import com.bizunited.empower.business.payment.entity.DefrayInfo;
import com.bizunited.empower.business.payment.repository.DefrayInfoRepository;
import com.bizunited.empower.business.payment.service.DefrayStrategy;
import com.bizunited.empower.business.payment.service.PaymentInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;

/**
 * 现金付款单
 *
 * @author Keller
 */
@Service
public class CashDefrayStrategy implements DefrayStrategy {
  @Autowired
  private DefrayInfoRepository defrayInfoRepository;
  @Autowired
  private PaymentInfoService paymentInfoService;

  @Override
  public Integer getFundsChannel() {
    return FundsChannelType.CASHPAY.getValue();
  }

  @Override
  @Transactional
  public void handler(DefrayInfo defrayInfo) {
    /*
     * 现金支付
     * 1、设置付款单状态为等待确认
     * 2、更新对应的应付账款的待确认金额
     */
    defrayInfo.setDefrayStatus(DefrayStatus.WAITFOR.getValue());
    defrayInfo = this.defrayInfoRepository.saveAndFlush(defrayInfo);
    this.paymentInfoService.waitPay(defrayInfo.getPaymentInfo().getPaymentCode(), defrayInfo.getDefrayAmount());
  }
}
