package com.bizunited.empower.business.payment.service.strategy;

import com.bizunited.empower.business.payment.common.enums.FundsChannelType;
import com.bizunited.empower.business.payment.common.enums.ReceiptStatus;
import com.bizunited.empower.business.payment.entity.ReceiptInfo;
import com.bizunited.empower.business.payment.repository.ReceiptInfoRepository;
import com.bizunited.empower.business.payment.service.ReceiptCancelStrategy;
import com.bizunited.empower.business.payment.service.ReceivableInfoService;
import com.bizunited.platform.common.service.invoke.InvokeParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;

/**
 * 现金支付取消
 *
 * @author Keller
 */
@Service
public class CashPayCancelStrategy implements ReceiptCancelStrategy {
  @Autowired
  private ReceiptInfoRepository receiptInfoRepository;
  @Autowired
  private ReceivableInfoService receivableInfoService;

  @Override
  public Integer getFundsChannel() {
    return FundsChannelType.CASHPAY.getValue();
  }

  @Override
  @Transactional
  public InvokeParams handler(ReceiptInfo receiptInfo, InvokeParams params) {
    /*
     * 现金支付
     * 1、设置收款单状态为取消确认
     * 2、更新对应的应收账款的待确认金额
     */
    receiptInfo.setReceiptStatus(ReceiptStatus.CANNEL.getValue());
    receiptInfo = this.receiptInfoRepository.saveAndFlush(receiptInfo);
    this.receivableInfoService.cancelWaitReceive(receiptInfo.getReceivableInfo().getReceivableCode(), receiptInfo.getReceiptAmount());
    return params;
  }
}
