package com.bizunited.empower.business.payment.service.strategy;

import com.bizunited.empower.business.payment.common.enums.DefrayStatus;
import com.bizunited.empower.business.payment.common.enums.FundsChannelType;
import com.bizunited.empower.business.payment.entity.DefrayInfo;
import com.bizunited.empower.business.payment.repository.DefrayInfoRepository;
import com.bizunited.empower.business.payment.service.DefrayStrategy;
import com.bizunited.empower.business.payment.service.PaymentInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;

/**
 * 信用应付单
 *
 * @author Keller
 */
@Service
public class CreditDefrayStrategy implements DefrayStrategy {
  @Autowired
  private DefrayInfoRepository defrayInfoRepository;
  @Autowired
  private PaymentInfoService paymentInfoService;

  @Override
  public Integer getFundsChannel() {
    return FundsChannelType.CREDITPAY.getValue();
  }

  @Override
  @Transactional
  public void handler(DefrayInfo defrayInfo) {
    /*
     * 信用应付
     * 1、直接添加金额
     */
    defrayInfo.setDefrayStatus(DefrayStatus.CONFIRMED.getValue());
    defrayInfo = this.defrayInfoRepository.saveAndFlush(defrayInfo);
    this.paymentInfoService.give(defrayInfo.getPaymentInfo().getPaymentCode(), defrayInfo.getDefrayAmount(), defrayInfo);
  }
}
