package com.bizunited.empower.business.payment.service.strategy;

import com.bizunited.empower.business.payment.common.enums.FundsChannelType;
import com.bizunited.empower.business.payment.entity.ReceiptInfo;
import com.bizunited.empower.business.payment.service.ReceiptCancelStrategy;
import com.bizunited.platform.common.service.invoke.InvokeParams;
import org.springframework.stereotype.Service;

/**
 * 信用支付取消
 *
 * @author Keller
 */
@Service
public class CreditPayCancelStrategy implements ReceiptCancelStrategy {

  @Override
  public Integer getFundsChannel() {
    return FundsChannelType.CREDITPAY.getValue();
  }

  @Override
  public InvokeParams handler(ReceiptInfo receiptInfo, InvokeParams params) {
    /*
     * 1、信用支付没有确认状态
     * 2、异常情况
     */
    throw new RuntimeException(String.format("信用支付无法取消，请检查收款单号：【%s】信息！", receiptInfo.getReceiptCode()));
  }
}
