package com.bizunited.empower.business.payment.service.strategy;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.empower.business.common.service.SignService;
import com.bizunited.empower.business.common.util.ResponseModelUtils;
import com.bizunited.empower.business.payment.common.enums.FundsChannelType;
import com.bizunited.empower.business.payment.common.enums.ReceiptStatus;
import com.bizunited.empower.business.payment.dto.PayDto;
import com.bizunited.empower.business.payment.entity.ReceiptInfo;
import com.bizunited.empower.business.payment.feign.PaymentFeignClient;
import com.bizunited.empower.business.payment.repository.ReceiptInfoRepository;
import com.bizunited.empower.business.payment.service.ReceiptCancelStrategy;
import com.bizunited.empower.business.payment.service.ReceivableInfoService;
import com.bizunited.empower.business.payment.vo.PayVo;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.service.invoke.InvokeParams;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;

/**
 * 小程序取消支付
 *
 * @author Keller
 */
@Service
public class MiniPayCancelStrategy implements ReceiptCancelStrategy {
  @Autowired
  private ReceiptInfoRepository receiptInfoRepository;
  @Autowired
  private ReceivableInfoService receivableInfoService;
  @Autowired
  private PaymentFeignClient paymentFeignClient;
  @Autowired
  private SignService signService;

  @Override
  public Integer getFundsChannel() {
    return FundsChannelType.WECHAYPAY.getValue();
  }

  @Override
  @Transactional
  public InvokeParams handler(ReceiptInfo receiptInfo, InvokeParams params) {
    /*
     * 小程序取消支付
     * 1、根据收款单调用取消订单接口
     * 2、关闭成功 取消应收账款额度
     * 3、关闭失败 抛出异常
     */
    PayDto dto = new PayDto();
    dto.setOrderNo(StringUtils.join(TenantUtils.getTenantCode(), "-", receiptInfo.getReceiptCode()));
    dto.setTenantCode(TenantUtils.getTenantCode());
    dto.setPaymentWay("80");

    String payInfo = JSONObject.toJSONString(dto);
    String sign = signService.sign(payInfo);
    ResponseModel result = paymentFeignClient.cancel(signService.getCurrentAppId(), sign, payInfo);
    ResponseModelUtils.validSuccess(result);
    PayVo payVo = ResponseModelUtils.getSuccessData(result, PayVo.class);
    Validate.notNull(payVo, "支付取消接口调用失败，请重试！");
    switch (payVo.getStatus()){
      case 2:
        // 成功
        receiptInfo.setReceiptStatus(ReceiptStatus.CANNEL.getValue());
        receiptInfo = this.receiptInfoRepository.saveAndFlush(receiptInfo);
        this.receivableInfoService.cancelWaitReceive(receiptInfo.getReceivableInfo().getReceivableCode(), receiptInfo.getReceiptAmount());
        break;
      case 1:
      case 3:
      default:
        throw new RuntimeException(payVo.getMessage());
    }
    return params;
  }

}
