package com.bizunited.empower.business.payment.vo;

import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Set;

/**
 * 应付账款信息Vo 按照单据模式查看
 *
 * @author Keller
 */
@SaturnEntity(name = "AssociatedPaymentVo", description = "应付账款信息Vo")
@ApiModel(value = "AssociatedPaymentVo", description = "应付账款信息Vo")
public class AssociatedPaymentVo extends UuidVo {

  /**
   * 
   */
  private static final long serialVersionUID = 3066329102901833313L;
  /**
   * 应付账款流水编号
   */
  @SaturnColumn(description = "应付账款流水编号")
  @ApiModelProperty("应付账款流水编号")
  private String paymentCode;
  /** 客户编号 */
  @ApiModelProperty("客户编号")
  @SaturnColumn(description = "客户编号")
  private String customerCode;
  /** 客户名称 */
  @ApiModelProperty("客户名称")
  @SaturnColumn(description = "客户名称")
  private String customerName;
  /**
   * 应付账款对应的关联单据编号
   */
  @SaturnColumn(description = "关联单据编号")
  @ApiModelProperty("关联单据编号")
  private String associatedCode;
  /**
   * 应付金额  应付金额=待付金额+已付金额
   *
   */
  @SaturnColumn(description = "应付金额")
  @ApiModelProperty("应付金额")
  private BigDecimal paymentAmount;
  /**
   * 待付金额 应付款单 待付取的金额
   */
  @SaturnColumn(description = "待付金额")
  @ApiModelProperty("待付金额")
  private BigDecimal waitPayAmount;
  /**
   * 待确认金额 待确认付取金额（该金额包含在待付金额中，是待付金额至已付金额的一个过渡状态金额）
   */
  @SaturnColumn(description = "待确认金额")
  @ApiModelProperty("待确认金额")
  private BigDecimal waitConfirmAmount;
  /**
   * 已付金额
   */
  @SaturnColumn(description = "已付金额")
  @ApiModelProperty("已付金额")
  private BigDecimal payedAmount;
  /**
   * 付款类型 其他付款:1,订单付款:2
   */
  @SaturnColumn(description = "付款类型 其他付款:1,订单付款:2")
  @ApiModelProperty("付款类型 其他付款:1,订单付款:2")
  private Integer paymentType;
  /**
   * 应付账款对应的一张或者多张付款单
   */
  @SaturnColumn(description = "付款单")
  @ApiModelProperty("付款单")
  private Set<DefrayInfoVo> defrayInfos;
  /**
   * 应付账款状态
   */
  @SaturnColumn(description = "应付账款状态")
  @ApiModelProperty("应付账款状态：未付款1、部分付款2、已付款3")
  private Integer paymentStatus;

  /**
   * 应付账款单据状态： 正常:1、报废:0
   */
  @SaturnColumn(description = "应付账款单据状态")
  @ApiModelProperty("应付账款单据状态：正常:1、报废:0")
  private Integer tstatus;

  public String getPaymentCode() {
    return paymentCode;
  }

  public void setPaymentCode(String paymentCode) {
    this.paymentCode = paymentCode;
  }

  public String getCustomerCode() {
    return customerCode;
  }

  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }

  public String getCustomerName() {
    return customerName;
  }

  public void setCustomerName(String customerName) {
    this.customerName = customerName;
  }

  public String getAssociatedCode() {
    return associatedCode;
  }

  public void setAssociatedCode(String associatedCode) {
    this.associatedCode = associatedCode;
  }

  public BigDecimal getPaymentAmount() {
    return paymentAmount;
  }

  public void setPaymentAmount(BigDecimal paymentAmount) {
    this.paymentAmount = paymentAmount;
  }

  public BigDecimal getWaitPayAmount() {
    return waitPayAmount;
  }

  public void setWaitPayAmount(BigDecimal waitPayAmount) {
    this.waitPayAmount = waitPayAmount;
  }

  public BigDecimal getWaitConfirmAmount() {
    return waitConfirmAmount;
  }

  public void setWaitConfirmAmount(BigDecimal waitConfirmAmount) {
    this.waitConfirmAmount = waitConfirmAmount;
  }

  public BigDecimal getPayedAmount() {
    return payedAmount;
  }

  public void setPayedAmount(BigDecimal payedAmount) {
    this.payedAmount = payedAmount;
  }

  public Integer getPaymentType() {
    return paymentType;
  }

  public void setPaymentType(Integer paymentType) {
    this.paymentType = paymentType;
  }

  public Set<DefrayInfoVo> getDefrayInfos() {
    return defrayInfos;
  }

  public void setDefrayInfos(Set<DefrayInfoVo> defrayInfos) {
    this.defrayInfos = defrayInfos;
  }

  public Integer getPaymentStatus() {
    return paymentStatus;
  }

  public void setPaymentStatus(Integer paymentStatus) {
    this.paymentStatus = paymentStatus;
  }

  public Integer getTstatus() {
    return tstatus;
  }

  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }
}
