package com.bizunited.empower.business.payment.vo;

import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Set;

/**
 * 应收账款信息Vo 按照单据模式查看
 *
 * @author Keller
 */
@SaturnEntity(name = "AssociatedReceivableVo", description = "应收账款信息Vo")
@ApiModel(value = "AssociatedReceivableVo", description = "应收账款信息Vo")
public class AssociatedReceivableVo extends UuidVo {

  /**
   * 
   */
  private static final long serialVersionUID = 3066329102901833313L;
  /**
   * 应收账款流水编号
   */
  @SaturnColumn(description = "应收账款流水编号")
  @ApiModelProperty("应收账款流水编号")
  private String receivableCode;
  /** 客户编号 */
  @ApiModelProperty("客户编号")
  @SaturnColumn(description = "客户编号")
  private String customerCode;
  /** 客户名称 */
  @ApiModelProperty("客户名称")
  @SaturnColumn(description = "客户名称")
  private String customerName;
  /**
   * 应收账款对应的关联单据编号
   */
  @SaturnColumn(description = "关联单据编号")
  @ApiModelProperty("关联单据编号")
  private String associatedCode;
  /**
   * 应收金额  应收金额=待收金额+已收金额
   *
   */
  @SaturnColumn(description = "应收金额")
  @ApiModelProperty("应收金额")
  private BigDecimal receivableAmount;
  /**
   * 待收金额 应收款单 待收取的金额
   */
  @SaturnColumn(description = "待收金额")
  @ApiModelProperty("待收金额")
  private BigDecimal waitReceiveAmount;
  /**
   * 待确认金额 待确认收取金额（该金额包含在待收金额中，是待收金额至已收金额的一个过渡状态金额）
   */
  @SaturnColumn(description = "待确认金额")
  @ApiModelProperty("待确认金额")
  private BigDecimal waitConfirmAmount;
  /**
   * 已收金额
   */
  @SaturnColumn(description = "已收金额")
  @ApiModelProperty("已收金额")
  private BigDecimal receivedAmount;
  /**
   * 收款类型 其他收款:1,订单收款:2
   */
  @SaturnColumn(description = "收款类型 其他收款:1,订单收款:2")
  @ApiModelProperty("收款类型 其他收款:1,订单收款:2")
  private Integer receivableType;
  /**
   * 应收账款对应的一张或者多张收款单
   */
  @SaturnColumn(description = "收款单")
  @ApiModelProperty("收款单")
  private Set<ReceiptInfoVo> receiptInfos;
  /**
   * 应收账款状态
   */
  @SaturnColumn(description = "应收账款状态")
  @ApiModelProperty("应收账款状态：未收款1、部分收款2、已收款3")
  private Integer receivableStatus;

  /**
   * 应收账款单据状态： 正常:1、报废:0
   */
  @SaturnColumn(description = "应收账款单据状态")
  @ApiModelProperty("应收账款单据状态：正常:1、报废:0")
  private Integer tstatus;

  public String getReceivableCode() {
    return receivableCode;
  }

  public void setReceivableCode(String receivableCode) {
    this.receivableCode = receivableCode;
  }

  public String getCustomerCode() {
    return customerCode;
  }

  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }

  public String getCustomerName() {
    return customerName;
  }

  public void setCustomerName(String customerName) {
    this.customerName = customerName;
  }

  public String getAssociatedCode() {
    return associatedCode;
  }

  public void setAssociatedCode(String associatedCode) {
    this.associatedCode = associatedCode;
  }

  public BigDecimal getReceivableAmount() {
    return receivableAmount;
  }

  public void setReceivableAmount(BigDecimal receivableAmount) {
    this.receivableAmount = receivableAmount;
  }

  public BigDecimal getWaitReceiveAmount() {
    return waitReceiveAmount;
  }

  public void setWaitReceiveAmount(BigDecimal waitReceiveAmount) {
    this.waitReceiveAmount = waitReceiveAmount;
  }

  public BigDecimal getWaitConfirmAmount() {
    return waitConfirmAmount;
  }

  public void setWaitConfirmAmount(BigDecimal waitConfirmAmount) {
    this.waitConfirmAmount = waitConfirmAmount;
  }

  public BigDecimal getReceivedAmount() {
    return receivedAmount;
  }

  public void setReceivedAmount(BigDecimal receivedAmount) {
    this.receivedAmount = receivedAmount;
  }

  public Integer getReceivableType() {
    return receivableType;
  }

  public void setReceivableType(Integer receivableType) {
    this.receivableType = receivableType;
  }

  public Integer getReceivableStatus() {
    return receivableStatus;
  }

  public void setReceivableStatus(Integer receivableStatus) {
    this.receivableStatus = receivableStatus;
  }

  public Integer getTstatus() {
    return tstatus;
  }

  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }

  public Set<ReceiptInfoVo> getReceiptInfos() {
    return receiptInfos;
  }

  public void setReceiptInfos(Set<ReceiptInfoVo> receiptInfos) {
    this.receiptInfos = receiptInfos;
  }
}
