package com.bizunited.empower.business.payment.vo;

import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * 客户信用Vo
 */
@SaturnEntity(name = "客户信用Vo", description = "客户信用Vo")
@ApiModel(value = "客户信用Vo", description = "客户信用Vo")
public class CustomerCreditVo extends UuidVo {
  private static final long serialVersionUID = 2591347144121785061L;
  /**
   * 客户信息
   */
  @ApiModelProperty("客户信息")
  @SaturnColumn(description = "客户信息")
  private String customerCode;
  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  @SaturnColumn(description = "客户名称")
  private String customerName;
  /**
   * 客户级别
   */
  @ApiModelProperty("客户级别")
  @SaturnColumn(description = "客户级别")
  private String customerLevel;
  /**
   * 客户分类
   */
  @ApiModelProperty("客户分类")
  @SaturnColumn(description = "客户分类")
  private String customerCategory;
  /**
   * 销售区域
   */
  @ApiModelProperty("销售区域")
  @SaturnColumn(description = "销售区域")
  private String salesAreaName;
  /**
   * 总额度
   */
  @SaturnColumn(description = "总额度")
  @ApiModelProperty("总额度")
  private BigDecimal totalAmount;

  /**
   * 已用额度
   */
  @SaturnColumn(description = "已用额度")
  @ApiModelProperty("已用额度")
  private BigDecimal usedAmount;

  /**
   * 剩余额度
   */
  @SaturnColumn(description = "剩余额度")
  @ApiModelProperty("剩余额度")
  private BigDecimal balance;
  /**
   * 用户信用状态： 正常:1、禁用:0
   */
  @SaturnColumn(description = "用户信用状态： 正常:1、禁用:0")
  @ApiModelProperty("用户信用状态： 正常:1、禁用:0")
  private Integer tstatus;

  public String getCustomerCode() {
    return customerCode;
  }

  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }

  public BigDecimal getTotalAmount() {
    return totalAmount;
  }

  public void setTotalAmount(BigDecimal totalAmount) {
    this.totalAmount = totalAmount;
  }

  public BigDecimal getUsedAmount() {
    return usedAmount;
  }

  public void setUsedAmount(BigDecimal usedAmount) {
    this.usedAmount = usedAmount;
  }

  public BigDecimal getBalance() {
    return balance;
  }

  public void setBalance(BigDecimal balance) {
    this.balance = balance;
  }

  public Integer getTstatus() {
    return tstatus;
  }

  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }

  public String getCustomerName() {
    return customerName;
  }

  public void setCustomerName(String customerName) {
    this.customerName = customerName;
  }

  public String getCustomerLevel() {
    return customerLevel;
  }

  public void setCustomerLevel(String customerLevel) {
    this.customerLevel = customerLevel;
  }

  public String getCustomerCategory() {
    return customerCategory;
  }

  public void setCustomerCategory(String customerCategory) {
    this.customerCategory = customerCategory;
  }

  public String getSalesAreaName() {
    return salesAreaName;
  }

  public void setSalesAreaName(String salesAreaName) {
    this.salesAreaName = salesAreaName;
  }
}
