package com.bizunited.empower.business.payment.vo;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 客户资金流水数据Vo
 *
 * @author Keller
 */
@SaturnEntity(name = "客户资金数据Vo", description = "客户资金数据Vo")
@ApiModel(value = "客户资金数据Vo", description = "客户资金数据Vo")
public class CustomerFundsBillVo implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 8798788483790288041L;
  /**
   * 应收账款对应的关联单据编号
   */
  @SaturnColumn(description = "关联单据编号")
  @ApiModelProperty("关联单据编号")
  private String associatedCode;
  /**
   * 金额
   */
  @SaturnColumn(description = "金额")
  @ApiModelProperty("金额")
  private BigDecimal amount;
  /**
   * 类型 应收:1,应付:2
   */
  @SaturnColumn(description = "类型 应收:1,应付:2")
  @ApiModelProperty("类型 应收:1,应付:2")
  private Integer type;
  /**
   * 业务类型 1、订单收款 2、订单退款 3、其他付款 4、其他付款
   */
  @SaturnColumn(description = "业务类型 1、订单收款 2、订单退款 3、其他付款 4、其他付款")
  @ApiModelProperty("业务类型 1、订单收款 2、订单退款 3、其他付款 4、其他付款")
  private Integer businessType;
  /**
   * 创建时间
   */
  @SaturnColumn(description = "创建时间")
  @ApiModelProperty("创建时间")
  private Date createTime;
  /**
   * 资金渠道
   */
  @SaturnColumn(description = "资金渠道 支付宝:1、微信小程序支付:2、聚合支付:3、现金支付:4、 银行转账:5、 信用支付:6")
  @ApiModelProperty("资金渠道 支付宝:1、微信小程序支付:2、银联支付:3、聚合支付:4、 银行转账:5、 信用支付:6")
  private Integer fundsChannel;

  public String getAssociatedCode() {
    return associatedCode;
  }

  public void setAssociatedCode(String associatedCode) {
    this.associatedCode = associatedCode;
  }

  public BigDecimal getAmount() {
    return amount;
  }

  public void setAmount(BigDecimal amount) {
    this.amount = amount;
  }

  public Integer getType() {
    return type;
  }

  public void setType(Integer type) {
    this.type = type;
  }

  public Integer getBusinessType() {
    return businessType;
  }

  public void setBusinessType(Integer businessType) {
    this.businessType = businessType;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public Integer getFundsChannel() {
    return fundsChannel;
  }

  public void setFundsChannel(Integer fundsChannel) {
    this.fundsChannel = fundsChannel;
  }
}
