package com.bizunited.empower.business.payment.vo;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 客户资金数据Vo
 * @author Keller
 */
@SaturnEntity(name = "客户资金数据Vo", description = "客户资金数据Vo")
@ApiModel(value = "客户资金数据Vo", description = "客户资金数据Vo")
public class CustomerFundsVo implements Serializable {
  private static final long serialVersionUID = -111782043619843249L;

  /** 客户编号 */
  @ApiModelProperty("客户编号")
  @SaturnColumn(description = "客户编号")
  private String customerCode;
  /** 收款 */
  @ApiModelProperty("收款")
  @SaturnColumn(description = "收款")
  private BigDecimal receiptAmount;
  /** 支付 */
  @ApiModelProperty("支付")
  @SaturnColumn(description = "支付")
  private BigDecimal defrayAmount;
  /**
   * 明细数据
   */
  List<CustomerFundsBillVo> customerFundsBillVos;

  public String getCustomerCode() {
    return customerCode;
  }

  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }

  public BigDecimal getReceiptAmount() {
    return receiptAmount;
  }

  public void setReceiptAmount(BigDecimal receiptAmount) {
    this.receiptAmount = receiptAmount;
  }

  public BigDecimal getDefrayAmount() {
    return defrayAmount;
  }

  public void setDefrayAmount(BigDecimal defrayAmount) {
    this.defrayAmount = defrayAmount;
  }

  public List<CustomerFundsBillVo> getCustomerFundsBillVos() {
    return customerFundsBillVos;
  }

  public void setCustomerFundsBillVos(List<CustomerFundsBillVo> customerFundsBillVos) {
    this.customerFundsBillVos = customerFundsBillVos;
  }
}
