package com.bizunited.empower.business.payment.vo;

import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * 应付账款信息Vo 按照单据模式查看
 *
 * @author Keller
 */
@SaturnEntity(name = "CustomerPaymentVo", description = "应付账款信息Vo 按照客户模式查看")
@ApiModel(value = "CustomerPaymentVo", description = "应付账款信息Vo 按照客户模式查看")
public class CustomerPaymentVo extends UuidVo {
  /**
   * 
   */
  private static final long serialVersionUID = 1018768372568060259L;
  /**
   * 客户编号
   */
  @ApiModelProperty("客户编号")
  @SaturnColumn(description = "客户编号")
  private String customerCode;
  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  @SaturnColumn(description = "客户名称")
  private String customerName;
  /**
   * 客户级别
   */
  @ApiModelProperty("客户级别")
  @SaturnColumn(description = "客户级别")
  private String customerLevel;
  /**
   * 客户分类
   */
  @ApiModelProperty("客户分类")
  @SaturnColumn(description = "客户分类")
  private String customerCategory;
  /**
   * 销售区域
   */
  @ApiModelProperty("销售区域")
  @SaturnColumn(description = "销售区域")
  private String salesName;
  /**
   * 应付账款单数量
   */
  @ApiModelProperty("应付账款单数量")
  @SaturnColumn(description = "应付账款单数量")
  private Integer paymentNum;
  /**
   * 应付金额
   */
  @ApiModelProperty("应付金额")
  @SaturnColumn(description = "应付金额")
  private BigDecimal paymentAmount;
  /**
   * 已付金额
   */
  @ApiModelProperty("已付金额")
  @SaturnColumn(description = "已付金额")
  private BigDecimal payedAmount;
  /**
   * 待付金额
   */
  @ApiModelProperty("待付金额")
  @SaturnColumn(description = "待付金额")
  private BigDecimal waitPayAmount;
  /**
   * 待确认金额
   */
  @ApiModelProperty("待确认金额")
  @SaturnColumn(description = "待确认金额")
  private BigDecimal waitConfirmAmount;

  public String getCustomerCode() {
    return customerCode;
  }

  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }

  public String getCustomerName() {
    return customerName;
  }

  public void setCustomerName(String customerName) {
    this.customerName = customerName;
  }

  public String getCustomerLevel() {
    return customerLevel;
  }

  public void setCustomerLevel(String customerLevel) {
    this.customerLevel = customerLevel;
  }

  public String getCustomerCategory() {
    return customerCategory;
  }

  public void setCustomerCategory(String customerCategory) {
    this.customerCategory = customerCategory;
  }

  public String getSalesName() {
    return salesName;
  }

  public void setSalesName(String salesName) {
    this.salesName = salesName;
  }

  public Integer getPaymentNum() {
    return paymentNum;
  }

  public void setPaymentNum(Integer paymentNum) {
    this.paymentNum = paymentNum;
  }

  public BigDecimal getPaymentAmount() {
    return paymentAmount;
  }

  public void setPaymentAmount(BigDecimal paymentAmount) {
    this.paymentAmount = paymentAmount;
  }

  public BigDecimal getPayedAmount() {
    return payedAmount;
  }

  public void setPayedAmount(BigDecimal payedAmount) {
    this.payedAmount = payedAmount;
  }

  public BigDecimal getWaitPayAmount() {
    return waitPayAmount;
  }

  public void setWaitPayAmount(BigDecimal waitPayAmount) {
    this.waitPayAmount = waitPayAmount;
  }

  public BigDecimal getWaitConfirmAmount() {
    return waitConfirmAmount;
  }

  public void setWaitConfirmAmount(BigDecimal waitConfirmAmount) {
    this.waitConfirmAmount = waitConfirmAmount;
  }
}
