package com.bizunited.empower.business.payment.vo;

import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * 应收账款信息Vo 按照单据模式查看
 *
 * @author Keller
 */
@SaturnEntity(name = "CustomerReceivableVo", description = "应收账款信息Vo 按照客户模式查看")
@ApiModel(value = "CustomerReceivableVo", description = "应收账款信息Vo 按照客户模式查看")
public class CustomerReceivableVo extends UuidVo {
  /**
   * 
   */
  private static final long serialVersionUID = 1018768372568060259L;
  /**
   * 客户编号
   */
  @ApiModelProperty("客户编号")
  @SaturnColumn(description = "客户编号")
  private String customerCode;
  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  @SaturnColumn(description = "客户名称")
  private String customerName;
  /**
   * 客户级别
   */
  @ApiModelProperty("客户级别")
  @SaturnColumn(description = "客户级别")
  private String customerLevel;
  /**
   * 客户分类
   */
  @ApiModelProperty("客户分类")
  @SaturnColumn(description = "客户分类")
  private String customerCategory;
  /**
   * 销售区域
   */
  @ApiModelProperty("销售区域")
  @SaturnColumn(description = "销售区域")
  private String salesName;
  /**
   * 应收账款单数量
   */
  @ApiModelProperty("应收账款单数量")
  @SaturnColumn(description = "应收账款单数量")
  private Long receivableNum;
  /**
   * 应收金额
   */
  @ApiModelProperty("应收金额")
  @SaturnColumn(description = "应收金额")
  private BigDecimal receivableAmount;
  /**
   * 已收金额
   */
  @ApiModelProperty("已收金额")
  @SaturnColumn(description = "已收金额")
  private BigDecimal receivedAmount;
  /**
   * 待收金额
   */
  @ApiModelProperty("待收金额")
  @SaturnColumn(description = "待收金额")
  private BigDecimal waitReceiveAmount;
  /**
   * 待确认金额
   */
  @ApiModelProperty("待确认金额")
  @SaturnColumn(description = "待确认金额")
  private BigDecimal waitConfirmAmount;

  public String getCustomerCode() {
    return customerCode;
  }

  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }

  public String getCustomerName() {
    return customerName;
  }

  public void setCustomerName(String customerName) {
    this.customerName = customerName;
  }

  public String getCustomerLevel() {
    return customerLevel;
  }

  public void setCustomerLevel(String customerLevel) {
    this.customerLevel = customerLevel;
  }

  public String getCustomerCategory() {
    return customerCategory;
  }

  public void setCustomerCategory(String customerCategory) {
    this.customerCategory = customerCategory;
  }

  public String getSalesName() {
    return salesName;
  }

  public void setSalesName(String salesName) {
    this.salesName = salesName;
  }

  public Long getReceivableNum() {
    return receivableNum;
  }

  public void setReceivableNum(Long receivableNum) {
    this.receivableNum = receivableNum;
  }

  public BigDecimal getReceivableAmount() {
    return receivableAmount;
  }

  public void setReceivableAmount(BigDecimal receivableAmount) {
    this.receivableAmount = receivableAmount;
  }

  public BigDecimal getReceivedAmount() {
    return receivedAmount;
  }

  public void setReceivedAmount(BigDecimal receivedAmount) {
    this.receivedAmount = receivedAmount;
  }

  public BigDecimal getWaitReceiveAmount() {
    return waitReceiveAmount;
  }

  public void setWaitReceiveAmount(BigDecimal waitReceiveAmount) {
    this.waitReceiveAmount = waitReceiveAmount;
  }

  public BigDecimal getWaitConfirmAmount() {
    return waitConfirmAmount;
  }

  public void setWaitConfirmAmount(BigDecimal waitConfirmAmount) {
    this.waitConfirmAmount = waitConfirmAmount;
  }
}
