package com.bizunited.empower.business.payment.vo;

import com.bizunited.platform.common.vo.TenantOpVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * 客户电子钱包VO
 * @Author: Paul Chan
 * @Date: 2021/4/12 下午3:06
 */
@SaturnEntity(name = "CustomerWalletVo", description = "客户电子钱包VO")
@ApiModel(value = "CustomerWalletVo", description = "客户电子钱包VO")
public class CustomerWalletVo extends TenantOpVo {
  private static final long serialVersionUID = 6054977329209293035L;

  /** 客户编码 */
  @ApiModelProperty("客户编码")
  @SaturnColumn(description = "客户编码")
  private String customerCode;

  /** 客户名称 */
  @ApiModelProperty("客户名称")
  @SaturnColumn(description = "客户名称")
  private String customerName;

  /**
   * 客户联系人
   */
  @SaturnColumn(description = "客户联系人")
  @ApiModelProperty("客户联系人")
  private String contactPerson;

  /**
   * 手机号
   */
  @SaturnColumn(description = "手机号")
  @ApiModelProperty("手机号")
  private String phone;

  /**
   * 销售区域名称
   */
  @SaturnColumn(description = "销售区域名称")
  @ApiModelProperty("销售区域名称")
  private String salesAreaName;

  /**
   * 余额
   */
  @SaturnColumn(description = "余额")
  @ApiModelProperty("余额")
  private BigDecimal balance;

  /**
   * 状态：0：已禁用，1：已启用
   */
  @ApiModelProperty("状态：0：已禁用，1：已启用")
  @SaturnColumn(description = "状态：0：已禁用，1：已启用")
  private Integer state;

  public String getCustomerCode() {
    return customerCode;
  }

  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }

  public String getCustomerName() {
    return customerName;
  }

  public void setCustomerName(String customerName) {
    this.customerName = customerName;
  }

  public BigDecimal getBalance() {
    return balance;
  }

  public void setBalance(BigDecimal balance) {
    this.balance = balance;
  }

  public Integer getState() {
    return state;
  }

  public void setState(Integer state) {
    this.state = state;
  }

  public String getContactPerson() {
    return contactPerson;
  }

  public void setContactPerson(String contactPerson) {
    this.contactPerson = contactPerson;
  }

  public String getPhone() {
    return phone;
  }

  public void setPhone(String phone) {
    this.phone = phone;
  }

  public String getSalesAreaName() {
    return salesAreaName;
  }

  public void setSalesAreaName(String salesAreaName) {
    this.salesAreaName = salesAreaName;
  }
}
