package com.bizunited.empower.business.payment.vo;

import com.bizunited.empower.business.payment.common.enums.FundsChannelType;
import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;

/**
 * 付款单信息Vo
 *
 * @author Keller
 */
@SaturnEntity(name = "DefrayInfoVo", description = "付款单信息Vo")
@ApiModel(value = "DefrayInfoVo", description = "付款单信息Vo")
public class DefrayInfoVo extends UuidVo {
  /**
   * 
   */
  private static final long serialVersionUID = -2673279999908664285L;

  /**
   * 付款单流水编号
   */
  @SaturnColumn(description = "付款单流水编号")
  @ApiModelProperty("付款单流水编号")
  private String defrayCode;
  /**
   * 应付账款客户编号
   */
  @SaturnColumn(description = "客户编号")
  @ApiModelProperty("客户编号")
  private String customerCode;
  /**
   * 应付账款客户名称
   */
  @SaturnColumn(description = "客户名称")
  @ApiModelProperty("客户名称")
  private String customerName;
  /**
   * 付款金额
   */
  @SaturnColumn(description = "付款金额")
  @ApiModelProperty(name = "付款金额", required = true)
  private BigDecimal defrayAmount;
  /**
   * 付款账户
   */
  @SaturnColumn(description = "付款账户")
  @ApiModelProperty("付款账户")
  private FundsAccountVo fundsAccount;
  /**
   * 付款单状态 待确认:1、已确认:2、已取消:0
   */
  @SaturnColumn(description = "付款单状态")
  @ApiModelProperty(name = "付款单状态：待确认:1、已确认:2、已取消:0", required = true)
  private Integer defrayStatus;
  /**
   * 资金渠道 {@link FundsChannelType}
   */
  @SaturnColumn(description = "资金渠道 支付宝:1、微信支付:2、聚合支付:3、现金支付:4、 银行转账:5、 信用支付:6")
  @ApiModelProperty(name = "资金渠道 支付宝:1、微信支付:2、银联支付:3、聚合支付:4、 银行转账:5、 信用支付:6", required = true)
  private Integer fundsChannel;
  /**
   * 备注信息
   */
  @SaturnColumn(description = "备注信息")
  @ApiModelProperty("备注信息")
  private String remark;
  /**
   * 付款单附件
   */
  @SaturnColumn(description = "付款单附件")
  @ApiModelProperty("付款单附件")
  private Set<DefrayAttachmentVo> defrayAttachments;

  /**
   * 应付账单
   */
  @SaturnColumn(description = "应付账单")
  @ApiModelProperty("应付账单")
  private PaymentInfoVo paymentInfo;
  /**
   * 付款时间
   */
  @ApiModelProperty(name = "defrayTime", value = "付款时间", required = true)
  @SaturnColumn(description = "付款时间")
  private Date defrayTime;

  public String getDefrayCode() {
    return defrayCode;
  }

  public void setDefrayCode(String defrayCode) {
    this.defrayCode = defrayCode;
  }

  public String getCustomerCode() {
    return customerCode;
  }

  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }

  public BigDecimal getDefrayAmount() {
    return defrayAmount;
  }

  public void setDefrayAmount(BigDecimal defrayAmount) {
    this.defrayAmount = defrayAmount;
  }

  public FundsAccountVo getFundsAccount() {
    return fundsAccount;
  }

  public void setFundsAccount(FundsAccountVo fundsAccount) {
    this.fundsAccount = fundsAccount;
  }

  public Integer getDefrayStatus() {
    return defrayStatus;
  }

  public void setDefrayStatus(Integer defrayStatus) {
    this.defrayStatus = defrayStatus;
  }

  public Integer getFundsChannel() {
    return fundsChannel;
  }

  public void setFundsChannel(Integer fundsChannel) {
    this.fundsChannel = fundsChannel;
  }

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  public Set<DefrayAttachmentVo> getDefrayAttachments() {
    return defrayAttachments;
  }

  public void setDefrayAttachments(Set<DefrayAttachmentVo> defrayAttachments) {
    this.defrayAttachments = defrayAttachments;
  }

  public Date getDefrayTime() {
    return defrayTime;
  }

  public void setDefrayTime(Date defrayTime) {
    this.defrayTime = defrayTime;
  }

  public String getCustomerName() {
    return customerName;
  }

  public void setCustomerName(String customerName) {
    this.customerName = customerName;
  }

  public PaymentInfoVo getPaymentInfo() {
    return paymentInfo;
  }

  public void setPaymentInfo(PaymentInfoVo paymentInfo) {
    this.paymentInfo = paymentInfo;
  }
}
