package com.bizunited.empower.business.payment.vo;

import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * ElectronicAccountRate 电子账户支付费率
 *
 * @Author: hefan
 * @Date: 2021/4/13 22:44
 */
@ApiModel(value = "ElectronicAccountRateVo", description = "电子账户支付费率")
public class ElectronicAccountRateVo extends UuidVo {

  private static final long serialVersionUID = -8013062945917138886L;

  /**
   *  saas端 手续费项目
   */
  @ApiModelProperty("手续费项目")
  @SaturnColumn(description = "手续费项目")
  private String rateItem;

  /**
   *  saas端 手续费项目数字编号 参考枚举：ElectronicAccountRateType
   */
  @ApiModelProperty("手续费项目数字编号 参考枚举：ElectronicAccountRateType")
  @SaturnColumn(description = "手续费项目数字编号 参考枚举：ElectronicAccountRateType")
  private Integer rateItemNum;

  /**
   *  saas端 收费对象 (1 全局 2 商户) 当为全局时，不存在电子账户外键
   */
  @ApiModelProperty("收费对象 (1 全局 2 商户) 当为全局时，不存在电子账户外键")
  @SaturnColumn(description = "收费对象 (1 全局 2 商户) 当为全局时，不存在电子账户外键")
  private Integer chargeObject;

  /**
   *  saas端 费率类型  2 固定金额 1 百分比
   */
  @ApiModelProperty("费率类型  2 固定金额 1 百分比")
  @SaturnColumn(description = "费率类型  2 固定金额 1 百分比")
  private Integer rateType;

  /**
   *  saas端 平台费率
   */
  @ApiModelProperty("平台费率")
  @SaturnColumn(description = "平台费率")
  private BigDecimal rate;

  /**
   *  saas端 中金费率
   */
  @ApiModelProperty("中金费率")
  @SaturnColumn(description = "中金费率")
  private BigDecimal cpcnRate;

  public String getRateItem() {
    return rateItem;
  }

  public void setRateItem(String rateItem) {
    this.rateItem = rateItem;
  }

  public Integer getRateItemNum() {
    return rateItemNum;
  }

  public void setRateItemNum(Integer rateItemNum) {
    this.rateItemNum = rateItemNum;
  }

  public Integer getChargeObject() {
    return chargeObject;
  }

  public void setChargeObject(Integer chargeObject) {
    this.chargeObject = chargeObject;
  }

  public Integer getRateType() {
    return rateType;
  }

  public void setRateType(Integer rateType) {
    this.rateType = rateType;
  }

  public BigDecimal getRate() {
    return rate;
  }

  public void setRate(BigDecimal rate) {
    this.rate = rate;
  }

  public BigDecimal getCpcnRate() {
    return cpcnRate;
  }

  public void setCpcnRate(BigDecimal cpcnRate) {
    this.cpcnRate = cpcnRate;
  }
}
