package com.bizunited.empower.business.payment.vo;

import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;

import java.math.BigDecimal;

/**
 * 提现VO
 * @author Keller
 */
@SaturnEntity(name = "ExtractCashVo", description = "提现VO")
@ApiModel(value = "ExtractCashVo", description = "提现VO")
public class ExtractCashVo {
  /**
   * 流水号
   */
  private String txSN;
  /**
   * 金额
   */
  private BigDecimal amount;
  /**
   * 手续费
   */
  private BigDecimal feeAmount;
  /**
   * 手续费率
   */
  private BigDecimal feeRate;
  /**
   * 实际金额
   */
  private BigDecimal realAmount;
  /**
   * 状态 1、处理中 2、成功 3、失败
   */
  private Integer status;
  /**
   * 备注
   */
  private String remark;


  public String getTxSN() {
    return txSN;
  }

  public void setTxSN(String txSN) {
    this.txSN = txSN;
  }

  public BigDecimal getAmount() {
    return amount;
  }

  public void setAmount(BigDecimal amount) {
    this.amount = amount;
  }

  public BigDecimal getFeeAmount() {
    return feeAmount;
  }

  public void setFeeAmount(BigDecimal feeAmount) {
    this.feeAmount = feeAmount;
  }

  public BigDecimal getFeeRate() {
    return feeRate;
  }

  public void setFeeRate(BigDecimal feeRate) {
    this.feeRate = feeRate;
  }

  public BigDecimal getRealAmount() {
    return realAmount;
  }

  public void setRealAmount(BigDecimal realAmount) {
    this.realAmount = realAmount;
  }

  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }
}
