package com.bizunited.empower.business.payment.vo;

import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 应收账款账号信息Vo
 *
 * @author Keller
 */
@SaturnEntity(name = "应收账款账号信息Vo", description = "应收账款账号信息Vo")
@ApiModel(value = "应收账款账号信息Vo", description = "应收账款账号信息Vo")
public class FundsAccountVo extends UuidVo {

  /**
   * 
   */
  private static final long serialVersionUID = 8930311617086090418L;

  /**
   * 账户名称
   */
  @SaturnColumn(description = "账户名称")
  @ApiModelProperty("账户名称")
  private String name;

  /**
   * 开户银行
   */
  @SaturnColumn(description = "开户银行")
  @ApiModelProperty("开户银行")
  private String bank;

  /**
   * 开户账号
   */
  @SaturnColumn(description = "开户账号")
  @ApiModelProperty("开户账号")
  private String account;

  /**
   * 账户状态 启用:1、禁用:0
   */
  @SaturnColumn(description = "账户状态 启用:1、禁用:0")
  @ApiModelProperty("账户状态 启用:1、禁用:0")
  private Integer accountStatus;

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getBank() {
    return bank;
  }

  public void setBank(String bank) {
    this.bank = bank;
  }

  public String getAccount() {
    return account;
  }

  public void setAccount(String account) {
    this.account = account;
  }

  public Integer getAccountStatus() {
    return accountStatus;
  }

  public void setAccountStatus(Integer accountStatus) {
    this.accountStatus = accountStatus;
  }
}
