package com.bizunited.empower.business.payment.vo;

import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;

/**
 * 支付信息Vo
 *
 * @author Keller
 */
@SaturnEntity(name = "PayVo", description = "支付信息Vo")
@ApiModel(value = "PayVo", description = "支付信息Vo")
public class PayVo {
  /**
   * 状态 1、待处理 2、成功 3、失败
   */
  private Integer status;
  /**
   * 订单编号
   */
  private String orderNo;
  /**
   * 流水号
   */
  private String txSN;
  /**
   * 支付宝微信聚合码二维码
   */
  private String qrCodeURL;
  /**
   * 支付宝微信聚合码二维码图片URL
   */
  private String qrImageURL;
  /**
   * 授权码
   */
  private String qrAuthCode;
  /**
   * 返回的消息
   */
  private String message;
  /**
   * 商户账号
   */
  private String merchantCode;

  public String getOrderNo() {
    return orderNo;
  }

  public void setOrderNo(String orderNo) {
    this.orderNo = orderNo;
  }

  public String getTxSN() {
    return txSN;
  }

  public void setTxSN(String txSN) {
    this.txSN = txSN;
  }

  public String getQrCodeURL() {
    return qrCodeURL;
  }

  public void setQrCodeURL(String qrCodeURL) {
    this.qrCodeURL = qrCodeURL;
  }

  public String getQrImageURL() {
    return qrImageURL;
  }

  public void setQrImageURL(String qrImageURL) {
    this.qrImageURL = qrImageURL;
  }

  public String getQrAuthCode() {
    return qrAuthCode;
  }

  public void setQrAuthCode(String qrAuthCode) {
    this.qrAuthCode = qrAuthCode;
  }

  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  public String getMerchantCode() {
    return merchantCode;
  }

  public void setMerchantCode(String merchantCode) {
    this.merchantCode = merchantCode;
  }

  @Override
  public String toString() {
    return "PayVo{" +
            "status=" + status +
            ", orderNo='" + orderNo + '\'' +
            ", txSN='" + txSN + '\'' +
            ", qrCodeURL='" + qrCodeURL + '\'' +
            ", qrImageURL='" + qrImageURL + '\'' +
            ", qrAuthCode='" + qrAuthCode + '\'' +
            ", message='" + message + '\'' +
            ", merchantCode='" + merchantCode + '\'' +
            '}';
  }
}
