package com.bizunited.empower.business.payment.vo;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * 应付账款 仪表盘Vo（主要涉及统计数据展示项目）
 *
 * @author Keller
 */
@SaturnEntity(name = "应付账款 仪表盘Vo（主要涉及统计数据展示项目）", description = "应付账款 仪表盘Vo（主要涉及统计数据展示项目）")
@ApiModel(value = "应付账款 仪表盘Vo（主要涉及统计数据展示项目）", description = "应付账款 仪表盘Vo（主要涉及统计数据展示项目）")
public class PaymentDashBoardVo {
  /**
   * 应付金额
   */
  @ApiModelProperty("应付金额")
  @SaturnColumn(description = "应付金额")
  private BigDecimal paymentAmount;
  /**
   * 待付金额
   */
  @ApiModelProperty("待付金额")
  @SaturnColumn(description = "待付金额")
  private BigDecimal waitPayAmount;
  /**
   * 待确认金额
   */
  @ApiModelProperty("待确认金额")
  @SaturnColumn(description = "待确认金额")
  private BigDecimal waitConfirmAmount;
  /**
   * 已付金额
   */
  @ApiModelProperty("已付金额")
  @SaturnColumn(description = "已付金额")
  private BigDecimal payedAmount;

  public BigDecimal getPaymentAmount() {
    return paymentAmount;
  }

  public void setPaymentAmount(BigDecimal paymentAmount) {
    this.paymentAmount = paymentAmount;
  }

  public BigDecimal getWaitPayAmount() {
    return waitPayAmount;
  }

  public void setWaitPayAmount(BigDecimal waitPayAmount) {
    this.waitPayAmount = waitPayAmount;
  }

  public BigDecimal getWaitConfirmAmount() {
    return waitConfirmAmount;
  }

  public void setWaitConfirmAmount(BigDecimal waitConfirmAmount) {
    this.waitConfirmAmount = waitConfirmAmount;
  }

  public BigDecimal getPayedAmount() {
    return payedAmount;
  }

  public void setPayedAmount(BigDecimal payedAmount) {
    this.payedAmount = payedAmount;
  }
}
