package com.bizunited.empower.business.payment.vo;

import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 收款单附件Vo
 *
 * @author Keller
 */
@SaturnEntity(name = "ReceiptInfoVo", description = "收款单信息Vo")
@ApiModel(value = "ReceiptInfoVo", description = "收款单信息Vo")
public class ReceiptAttachmentVo extends UuidVo {

  /**
   * 
   */
  private static final long serialVersionUID = -2754577592046916332L;
  /**
   * 收款单编号
   */
  @ApiModelProperty("收款单编号")
  @SaturnColumn(description = "收款单编号")
  private ReceiptInfoVo receiptInfo;
  /**
   * 相对路径
   */
  @SaturnColumn(description = "相对路径")
  @ApiModelProperty("相对路径")
  private String relativePath;
  /**
   * 原始文件名
   */
  @SaturnColumn(description = "原始文件名")
  @ApiModelProperty("原始文件名")
  private String fileName;
  /**
   * 重命名后的文件名
   */
  @SaturnColumn(description = "重命名后的文件名")
  @ApiModelProperty("重命名后的文件名")
  private String reFileName;

  public ReceiptInfoVo getReceiptInfo() {
    return receiptInfo;
  }

  public void setReceiptInfo(ReceiptInfoVo receiptInfo) {
    this.receiptInfo = receiptInfo;
  }

  public String getRelativePath() {
    return relativePath;
  }

  public void setRelativePath(String relativePath) {
    this.relativePath = relativePath;
  }

  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  public String getReFileName() {
    return reFileName;
  }

  public void setReFileName(String reFileName) {
    this.reFileName = reFileName;
  }
}
