package com.bizunited.empower.business.payment.vo;

import com.bizunited.empower.business.payment.common.enums.FundsChannelType;
import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;

/**
 * 收款单信息Vo
 *
 * @author Keller
 */
@SaturnEntity(name = "ReceiptInfoVo", description = "收款单信息Vo")
@ApiModel(value = "ReceiptInfoVo", description = "收款单信息Vo")
public class ReceiptInfoVo extends UuidVo {

  /**
   * 
   */
  private static final long serialVersionUID = -2673279999908664285L;
  @SaturnColumn(description = "收款单流水编号")
  @ApiModelProperty("收款单流水编号")
  private String receiptCode;
  /**
   * 应收账款客户编号
   */
  @SaturnColumn(description = "客户编号")
  @ApiModelProperty("客户编号")
  private String customerCode;
  /**
   * 应收账款客户名称
   */
  @SaturnColumn(description = "客户名称")
  @ApiModelProperty("客户名称")
  private String customerName;
  /**
   * 收款金额
   */
  @SaturnColumn(description = "收款金额")
  @ApiModelProperty("收款金额")
  private BigDecimal receiptAmount;
  /**
   * 收款账户
   */
  @SaturnColumn(description = "收款账户")
  @ApiModelProperty("收款账户")
  private FundsAccountVo receivableAccount;
  /**
   * 收款单状态 待确认:1、已确认:2、已取消:0
   */
  @SaturnColumn(description = "收款单状态")
  @ApiModelProperty("收款单状态：待确认:1、已确认:2、已取消:0")
  private Integer receiptStatus;
  /**
   * 资金渠道 {@link FundsChannelType}
   */
  @SaturnColumn(description = "资金渠道 支付宝:1、微信支付:2、聚合支付:3、现金支付:4、 银行转账:5、 信用支付:6")
  @ApiModelProperty("资金渠道 支付宝:1、微信支付:2、银联支付:3、聚合支付:4、 银行转账:5、 信用支付:6")
  private Integer fundsChannel;
  /**
   * 备注信息
   */
  @SaturnColumn(description = "备注信息")
  @ApiModelProperty("备注信息")
  private String remark;
  /**
   * 收款单附件
   */
  @SaturnColumn(description = "收款单附件")
  @ApiModelProperty("收款单附件")
  private Set<ReceiptAttachmentVo> receiptAttachments;
  /**
   * 应收账款单
   */
  @SaturnColumn(description = "应收账款单")
  @ApiModelProperty("应收账款单")
  private ReceivableInfoVo receivableInfo;
  /**
   * 收款时间
   */
  @ApiModelProperty(name = "receiptTime", value = "收款时间")
  @SaturnColumn(description = "收款时间")
  private Date receiptTime;
  /**
   * 扩展信息
   */
  @ApiModelProperty(name = "extend", value = "扩展信息")
  @SaturnColumn(description = "扩展信息")
  private String extend;

  public String getReceiptCode() {
    return receiptCode;
  }

  public void setReceiptCode(String receiptCode) {
    this.receiptCode = receiptCode;
  }

  public String getCustomerCode() {
    return customerCode;
  }

  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }

  public BigDecimal getReceiptAmount() {
    return receiptAmount;
  }

  public void setReceiptAmount(BigDecimal receiptAmount) {
    this.receiptAmount = receiptAmount;
  }

  public FundsAccountVo getReceivableAccount() {
    return receivableAccount;
  }

  public void setReceivableAccount(FundsAccountVo receivableAccount) {
    this.receivableAccount = receivableAccount;
  }

  public Integer getReceiptStatus() {
    return receiptStatus;
  }

  public void setReceiptStatus(Integer receiptStatus) {
    this.receiptStatus = receiptStatus;
  }

  public Integer getFundsChannel() {
    return fundsChannel;
  }

  public void setFundsChannel(Integer fundsChannel) {
    this.fundsChannel = fundsChannel;
  }

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  public Set<ReceiptAttachmentVo> getReceiptAttachments() {
    return receiptAttachments;
  }

  public void setReceiptAttachments(Set<ReceiptAttachmentVo> receiptAttachments) {
    this.receiptAttachments = receiptAttachments;
  }

  public Date getReceiptTime() {
    return receiptTime;
  }

  public void setReceiptTime(Date receiptTime) {
    this.receiptTime = receiptTime;
  }

  public String getCustomerName() {
    return customerName;
  }

  public void setCustomerName(String customerName) {
    this.customerName = customerName;
  }

  public ReceivableInfoVo getReceivableInfo() {
    return receivableInfo;
  }

  public void setReceivableInfo(ReceivableInfoVo receivableInfo) {
    this.receivableInfo = receivableInfo;
  }

  public String getExtend() {
    return extend;
  }

  public void setExtend(String extend) {
    this.extend = extend;
  }
}
