package com.bizunited.empower.business.payment.vo;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * 应收账款 仪表盘Vo（主要涉及统计数据展示项目）
 *
 * @author Keller
 */
@SaturnEntity(name = "应收账款 仪表盘Vo（主要涉及统计数据展示项目）", description = "应收账款 仪表盘Vo（主要涉及统计数据展示项目）")
@ApiModel(value = "应收账款 仪表盘Vo（主要涉及统计数据展示项目）", description = "应收账款 仪表盘Vo（主要涉及统计数据展示项目）")
public class ReceivableDashBoardVo {
  /**
   * 应收金额
   */
  @ApiModelProperty("应收金额")
  @SaturnColumn(description = "应收金额")
  private BigDecimal receivableAmount;
  /**
   * 待收金额
   */
  @ApiModelProperty("待收金额")
  @SaturnColumn(description = "待收金额")
  private BigDecimal waitReceiveAmount;
  /**
   * 待确认金额
   */
  @ApiModelProperty("待确认金额")
  @SaturnColumn(description = "待确认金额")
  private BigDecimal waitConfirmAmount;
  /**
   * 已收金额
   */
  @ApiModelProperty("已收金额")
  @SaturnColumn(description = "已收金额")
  private BigDecimal receivedAmount;

  public BigDecimal getReceivableAmount() {
    return receivableAmount;
  }

  public void setReceivableAmount(BigDecimal receivableAmount) {
    this.receivableAmount = receivableAmount;
  }

  public BigDecimal getWaitReceiveAmount() {
    return waitReceiveAmount;
  }

  public void setWaitReceiveAmount(BigDecimal waitReceiveAmount) {
    this.waitReceiveAmount = waitReceiveAmount;
  }

  public BigDecimal getWaitConfirmAmount() {
    return waitConfirmAmount;
  }

  public void setWaitConfirmAmount(BigDecimal waitConfirmAmount) {
    this.waitConfirmAmount = waitConfirmAmount;
  }

  public BigDecimal getReceivedAmount() {
    return receivedAmount;
  }

  public void setReceivedAmount(BigDecimal receivedAmount) {
    this.receivedAmount = receivedAmount;
  }
}
