package com.bizunited.empower.business.payment.vo;

import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 供应商应收账单Vo
 *
 * @author Keller
 */
@SaturnEntity(name = "供应商应收账单Vo", description = "供应商应收账单Vo")
@ApiModel(value = "供应商应收账单Vo", description = "供应商应收账单Vo")
public class SupplierPaymentInfoVo extends UuidVo {
  private static final long serialVersionUID = 5468827248281685983L;
  /**
   * 应付账款流水编号
   */
  @SaturnColumn(description = "应付账款流水编号")
  @ApiModelProperty("应付账款流水编号")
  private String paymentCode;
  /** 供应商编号 */
  @ApiModelProperty("供应商编号")
  @SaturnColumn(description = "供应商编号")
  private String supplierCode;
  /** 供应商名称 */
  @ApiModelProperty("供应商名称")
  @SaturnColumn(description = "供应商名称")
  private String supplierName;
  /**
   * 应付账款对应的关联单据编号
   */
  @SaturnColumn(description = "关联单据编号")
  @ApiModelProperty("关联单据编号")
  private String associatedCode;
  /**
   * 应付金额  应付金额=待付金额+已付金额
   */
  @SaturnColumn(description = "应付金额")
  @ApiModelProperty("应付金额")
  private BigDecimal payAmount;
  /**
   * 待付金额 应付款单 待支付的金额
   */
  @SaturnColumn(description = "待付金额")
  @ApiModelProperty("待付金额")
  private BigDecimal waitPayAmount;
  /**
   * 已付金额
   */
  @SaturnColumn(description = "已付金额")
  @ApiModelProperty("已付金额")
  private BigDecimal payedAmount;
  /**
   * 应付账款状态：未付款1、已付款2
   */
  @SaturnColumn(description = "应付账款状态")
  @ApiModelProperty("应付账款状态：未付款1、已付款2")
  private Integer paymentStatus;
  /**
   * 应付账款单据状态： 正常:1、报废:0
   */
  @SaturnColumn(description = "应付账款单据状态")
  @ApiModelProperty("应付账款单据状态：正常:1、报废:0")
  private Integer tstatus;

  @SaturnColumn(description = "支付时间")
  @ApiModelProperty("支付时间")
  private Date payTime;

  public String getPaymentCode() {
    return paymentCode;
  }

  public void setPaymentCode(String paymentCode) {
    this.paymentCode = paymentCode;
  }

  public String getSupplierCode() {
    return supplierCode;
  }

  public void setSupplierCode(String supplierCode) {
    this.supplierCode = supplierCode;
  }

  public String getSupplierName() {
    return supplierName;
  }

  public void setSupplierName(String supplierName) {
    this.supplierName = supplierName;
  }

  public String getAssociatedCode() {
    return associatedCode;
  }

  public void setAssociatedCode(String associatedCode) {
    this.associatedCode = associatedCode;
  }

  public BigDecimal getPayAmount() {
    return payAmount;
  }

  public void setPayAmount(BigDecimal payAmount) {
    this.payAmount = payAmount;
  }

  public BigDecimal getWaitPayAmount() {
    return waitPayAmount;
  }

  public void setWaitPayAmount(BigDecimal waitPayAmount) {
    this.waitPayAmount = waitPayAmount;
  }

  public BigDecimal getPayedAmount() {
    return payedAmount;
  }

  public void setPayedAmount(BigDecimal payedAmount) {
    this.payedAmount = payedAmount;
  }

  public Integer getPaymentStatus() {
    return paymentStatus;
  }

  public void setPaymentStatus(Integer paymentStatus) {
    this.paymentStatus = paymentStatus;
  }

  public Integer getTstatus() {
    return tstatus;
  }

  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }

  public Date getPayTime() {
    return payTime;
  }

  public void setPayTime(Date payTime) {
    this.payTime = payTime;
  }
}
