package com.bizunited.empower.business.payment.vo;

import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 供应商应付账单Vo
 *
 * @author Keller
 */
@SaturnEntity(name = "供应商应付账单Vo", description = "供应商应付账单Vo")
@ApiModel(value = "供应商应付账单Vo", description = "供应商应付账单Vo")
public class SupplierReceivableInfoVo extends UuidVo {
  private static final long serialVersionUID = 721763307241152938L;

  /**
   * 应收账款流水编号
   */
  @SaturnColumn(description = "应收账款流水编号")
  @ApiModelProperty("应收账款流水编号")
  private String receivableCode;
  /** 供应商编号 */
  @ApiModelProperty("客户编号")
  @SaturnColumn(description = "客户编号")
  private String supplierCode;
  /** 供应商名称 */
  @ApiModelProperty("客户名称")
  @SaturnColumn(description = "客户名称")
  private String supplierName;
  /**
   * 应收账款对应的关联单据编号
   */
  @SaturnColumn(description = "关联单据编号")
  @ApiModelProperty("关联单据编号")
  private String associatedCode;
  /**
   * 应收金额  应收金额=待收金额+已收金额
   *
   */
  @SaturnColumn(description = "应收金额")
  @ApiModelProperty("应收金额")
  private BigDecimal receivableAmount;
  /**
   * 待收金额 应收款单 待收取的金额
   */
  @SaturnColumn(description = "待收金额")
  @ApiModelProperty("待收金额")
  private BigDecimal waitReceiveAmount;
  /**
   * 已收金额
   */
  @SaturnColumn(description = "已收金额")
  @ApiModelProperty("已收金额")
  private BigDecimal receivedAmount;
  /**
   * 应收账款状态 未收款1、已收款2
   */
  @SaturnColumn(description = "应收账款状态 未收款1、已收款2")
  @ApiModelProperty("应收账款状态 未收款1、已收款2")
  private Integer receivableStatus;
  /**
   * 应收账款单据状态： 正常:1、报废:0
   */
  @SaturnColumn(description = "应收账款单据状态")
  @ApiModelProperty("应收账款单据状态：正常:1、报废:0")
  private Integer tstatus;

  @SaturnColumn(description = "支付时间")
  @ApiModelProperty("支付时间")
  private Date receivableTime;

  public String getReceivableCode() {
    return receivableCode;
  }

  public void setReceivableCode(String receivableCode) {
    this.receivableCode = receivableCode;
  }

  public String getSupplierCode() {
    return supplierCode;
  }

  public void setSupplierCode(String supplierCode) {
    this.supplierCode = supplierCode;
  }

  public String getSupplierName() {
    return supplierName;
  }

  public void setSupplierName(String supplierName) {
    this.supplierName = supplierName;
  }

  public String getAssociatedCode() {
    return associatedCode;
  }

  public void setAssociatedCode(String associatedCode) {
    this.associatedCode = associatedCode;
  }

  public BigDecimal getReceivableAmount() {
    return receivableAmount;
  }

  public void setReceivableAmount(BigDecimal receivableAmount) {
    this.receivableAmount = receivableAmount;
  }

  public BigDecimal getWaitReceiveAmount() {
    return waitReceiveAmount;
  }

  public void setWaitReceiveAmount(BigDecimal waitReceiveAmount) {
    this.waitReceiveAmount = waitReceiveAmount;
  }

  public BigDecimal getReceivedAmount() {
    return receivedAmount;
  }

  public void setReceivedAmount(BigDecimal receivedAmount) {
    this.receivedAmount = receivedAmount;
  }

  public Integer getReceivableStatus() {
    return receivableStatus;
  }

  public void setReceivableStatus(Integer receivableStatus) {
    this.receivableStatus = receivableStatus;
  }

  public Integer getTstatus() {
    return tstatus;
  }

  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }

  public Date getReceivableTime() {
    return receivableTime;
  }

  public void setReceivableTime(Date receivableTime) {
    this.receivableTime = receivableTime;
  }
}
