/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.aspect;

import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.customer.entity.Customer;
import com.bizunited.empower.business.customer.service.CustomerService;
import com.bizunited.empower.business.policy.service.SalePolicyVoService;
import com.bizunited.empower.business.policy.vo.PolicyTypeVo;
import com.bizunited.empower.business.policy.vo.SalePolicyProductsVo;
import com.bizunited.empower.business.policy.vo.SalePolicyVo;
import com.bizunited.empower.business.product.vo.ProductPreferentialItemVo;
import com.bizunited.empower.business.product.vo.ProductSpecificationVo;
import com.bizunited.empower.business.product.vo.ProductUnitSpecificationAndPriceVo;
import com.bizunited.empower.business.product.vo.ProductVo;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Aspect
@Component
public class PreferentialAspect {
    @Autowired
    private CustomerService customerService;
    @Autowired
    private SalePolicyVoService salePolicyVoService;

    @Pointcut(value="@annotation(com.bizunited.empower.business.product.common.aspect.LabelPreferentialItems)")
    private void cutMethod() {
    }

    @Around(value="cutMethod()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Object result;
        block20: {
            ProductSpecificationVo targetItem;
            Map productCodeMapping;
            Map<Object, Object> specificationCodeMapping;
            String customerCode;
            Customer customer;
            String tenantCode;
            block21: {
                String productSpecificationCode;
                block19: {
                    String userAccount;
                    result = joinPoint.proceed();
                    if (result == null) {
                        return result;
                    }
                    tenantCode = TenantUtils.getTenantCode();
                    if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tenantCode, userAccount = SecurityUtils.getUserAccount()})) {
                        return result;
                    }
                    customer = this.customerService.findByTenantCodeAndCustomerCode(tenantCode, userAccount);
                    if (customer == null) {
                        customer = this.customerService.findByPhoneAntTenantCode(userAccount);
                    }
                    customerCode = null;
                    if (customer != null) {
                        customerCode = customer.getCustomerCode();
                    }
                    specificationCodeMapping = Maps.newHashMap();
                    productCodeMapping = Maps.newHashMap();
                    if (!(result instanceof ProductSpecificationVo)) break block19;
                    ProductSpecificationVo productSpecification = (ProductSpecificationVo)result;
                    String productSpecificationCode2 = productSpecification.getProductSpecificationCode();
                    specificationCodeMapping = this.specificationCodeMapping(Lists.newArrayList((Object[])new String[]{productSpecificationCode2}), StringUtils.isNotBlank((CharSequence)customerCode), tenantCode, customerCode);
                    productSpecification.setPreferentialItems((Set)specificationCodeMapping.get(productSpecificationCode2));
                    break block20;
                }
                if (!(result instanceof ProductVo)) break block21;
                ProductVo product = (ProductVo)result;
                String productCode = product.getProductCode();
                Set productSpecifications = product.getProductSpecifications();
                Set productUnitSpecificationAndPrices = product.getProductUnitSpecificationAndPrices();
                List<Object> productSpecificationCodes = Lists.newArrayList();
                if (!CollectionUtils.isEmpty((Collection)productSpecifications)) {
                    productSpecificationCodes = productSpecifications.stream().map(ProductSpecificationVo::getProductSpecificationCode).collect(Collectors.toList());
                }
                Pair<Map<String, Set<ProductPreferentialItemVo>>, Map<String, Set<ProductPreferentialItemVo>>> resutlsMapping = this.productCodeMapping(Lists.newArrayList((Object[])new String[]{productCode}), productSpecificationCodes, tenantCode, customerCode);
                productCodeMapping = (Map)resutlsMapping.getLeft();
                specificationCodeMapping = (Map)resutlsMapping.getRight();
                product.setPreferentialItems((Set)productCodeMapping.get(productCode));
                if (!CollectionUtils.isEmpty((Collection)productSpecifications)) {
                    for (ProductSpecificationVo productSpecification : productSpecifications) {
                        productSpecificationCode = productSpecification.getProductSpecificationCode();
                        productSpecification.setPreferentialItems((Set)specificationCodeMapping.get(productSpecificationCode));
                    }
                }
                for (ProductUnitSpecificationAndPriceVo productUnitSpecificationAndPriceVo : productUnitSpecificationAndPrices) {
                    productSpecificationCode = productUnitSpecificationAndPriceVo.getProductSpecification().getProductSpecificationCode();
                    productUnitSpecificationAndPriceVo.getProductSpecification().setPreferentialItems((Set)specificationCodeMapping.get(productSpecificationCode));
                }
                break block20;
            }
            if (!(result instanceof Iterable)) break block20;
            Iterable results = (Iterable)result;
            LinkedHashSet exsitsProductCodes = Sets.newLinkedHashSet();
            LinkedHashSet exsitsProductSpecificationCodes = Sets.newLinkedHashSet();
            boolean isProduct = false;
            for (Object resultItem : results) {
                if (resultItem instanceof ProductSpecificationVo) {
                    targetItem = (ProductSpecificationVo)resultItem;
                    String productSpecificationCode = targetItem.getProductSpecificationCode();
                    exsitsProductSpecificationCodes.add(productSpecificationCode);
                    isProduct = false;
                    continue;
                }
                if (!(resultItem instanceof ProductVo)) continue;
                targetItem = (ProductVo)resultItem;
                String productCode = targetItem.getProductCode();
                exsitsProductCodes.add(productCode);
                Set productSpecifications = targetItem.getProductSpecifications();
                if (!CollectionUtils.isEmpty((Collection)productSpecifications)) {
                    productSpecifications.stream().forEach(item -> exsitsProductSpecificationCodes.add(item.getProductSpecificationCode()));
                }
                isProduct = true;
            }
            if (!isProduct) {
                specificationCodeMapping = this.specificationCodeMapping(Lists.newArrayList((Iterable)exsitsProductSpecificationCodes), customer != null, tenantCode, customerCode);
                if (CollectionUtils.isEmpty(specificationCodeMapping)) {
                    return result;
                }
            } else {
                Pair<Map<String, Set<ProductPreferentialItemVo>>, Map<String, Set<ProductPreferentialItemVo>>> resutlsMapping = this.productCodeMapping(Lists.newArrayList((Iterable)exsitsProductCodes), Lists.newArrayList((Iterable)exsitsProductSpecificationCodes), tenantCode, customerCode);
                productCodeMapping = (Map)resutlsMapping.getLeft();
                specificationCodeMapping = (Map)resutlsMapping.getRight();
                if (CollectionUtils.isEmpty((Map)productCodeMapping)) {
                    return result;
                }
            }
            for (Object resultItem : results) {
                if (resultItem instanceof ProductSpecificationVo) {
                    targetItem = (ProductSpecificationVo)resultItem;
                    targetItem.setPreferentialItems((Set)specificationCodeMapping.get(targetItem.getProductSpecificationCode()));
                    continue;
                }
                if (!(resultItem instanceof ProductVo)) continue;
                targetItem = (ProductVo)resultItem;
                targetItem.setPreferentialItems((Set)productCodeMapping.get(targetItem.getProductCode()));
                Set productSpecifications = targetItem.getProductSpecifications();
                for (ProductSpecificationVo productSpecification : productSpecifications) {
                    String productSpecificationCode = productSpecification.getProductSpecificationCode();
                    productSpecification.setPreferentialItems((Set)specificationCodeMapping.get(productSpecificationCode));
                }
                Set productUnitSpecificationAndPriceVos = targetItem.getProductUnitSpecificationAndPrices();
                for (ProductUnitSpecificationAndPriceVo productUnitSpecificationAndPriceVo : productUnitSpecificationAndPriceVos) {
                    String productSpecificationCode = productUnitSpecificationAndPriceVo.getProductSpecification().getProductSpecificationCode();
                    productUnitSpecificationAndPriceVo.getProductSpecification().setPreferentialItems((Set)specificationCodeMapping.get(productSpecificationCode));
                }
            }
        }
        return result;
    }

    private Pair<Map<String, Set<ProductPreferentialItemVo>>, Map<String, Set<ProductPreferentialItemVo>>> productCodeMapping(List<String> productCodes, List<String> productSpecificationCodes, String tenantCode, String customerCode) {
        Set<Object> salePolicies = Sets.newHashSet();
        ConcurrentMap productCodeMapping = Maps.newConcurrentMap();
        ConcurrentMap specificationCodeMapping = Maps.newConcurrentMap();
        salePolicies = StringUtils.isNotBlank((CharSequence)customerCode) ? this.salePolicyVoService.findDetailsByEffectiveAndCustomerCode(tenantCode, true, customerCode) : this.salePolicyVoService.findDetailsByEffective(tenantCode, true);
        if (CollectionUtils.isEmpty((Collection)salePolicies)) {
            return Pair.of((Object)Maps.newLinkedHashMap(), (Object)Maps.newLinkedHashMap());
        }
        for (SalePolicyVo salePolicy : salePolicies) {
            Integer saleType;
            String tagName;
            Set<SalePolicyProductsVo> salePolicyProducts = salePolicy.getProducts();
            ProductPreferentialItemVo preferentialItem = new ProductPreferentialItemVo();
            PolicyTypeVo policyType = salePolicy.getPolicyType();
            if (policyType == null || StringUtils.isBlank((CharSequence)(tagName = this.getTagName(saleType = policyType.getSaleType())))) continue;
            preferentialItem.setTag(tagName);
            preferentialItem.setCode(salePolicy.getSalePolicyCode());
            preferentialItem.setName(salePolicy.getSalePolicyName());
            preferentialItem.setValidStartTime(salePolicy.getValidStartTime());
            preferentialItem.setValidEndTime(salePolicy.getValidEndTime());
            preferentialItem.setDescription(salePolicy.getDescription());
            salePolicyProducts.stream().filter(item -> productCodes.contains(item.getProductCode())).forEach(item -> {
                String itemProductCode = item.getProductCode();
                Set preferentialItems = (Set)productCodeMapping.get(itemProductCode);
                if (!CollectionUtils.isEmpty((Collection)preferentialItems)) {
                    preferentialItems.add(preferentialItem);
                } else {
                    preferentialItems = Sets.newHashSet();
                    preferentialItems.add(preferentialItem);
                }
                productCodeMapping.put(itemProductCode, preferentialItems);
            });
            salePolicyProducts.stream().filter(item -> productSpecificationCodes.contains(item.getProductSpecificationCode())).forEach(item -> {
                String productSpecificationCode = item.getProductSpecificationCode();
                Set preferentialItems = (Set)specificationCodeMapping.get(productSpecificationCode);
                if (!CollectionUtils.isEmpty((Collection)preferentialItems)) {
                    preferentialItems.add(preferentialItem);
                } else {
                    preferentialItems = Sets.newHashSet();
                    preferentialItems.add(preferentialItem);
                }
                specificationCodeMapping.put(productSpecificationCode, preferentialItems);
            });
        }
        return Pair.of((Object)productCodeMapping, (Object)specificationCodeMapping);
    }

    private Map<String, Set<ProductPreferentialItemVo>> specificationCodeMapping(List<String> productSpecificationCodes, boolean isCustomer, String tenantCode, String customerCode) {
        Set<Object> salePolicies = Sets.newHashSet();
        ConcurrentMap specificationCodeMapping = Maps.newConcurrentMap();
        salePolicies = isCustomer ? this.salePolicyVoService.findDetailsByEffectiveAndCustomerCode(tenantCode, true, customerCode) : this.salePolicyVoService.findDetailsByEffective(tenantCode, true);
        if (CollectionUtils.isEmpty((Collection)salePolicies)) {
            return Maps.newHashMap();
        }
        for (SalePolicyVo salePolicy : salePolicies) {
            Integer saleType;
            String tagName;
            Set<SalePolicyProductsVo> salePolicyProducts = salePolicy.getProducts();
            ProductPreferentialItemVo preferentialItem = new ProductPreferentialItemVo();
            PolicyTypeVo policyType = salePolicy.getPolicyType();
            if (policyType == null || StringUtils.isBlank((CharSequence)(tagName = this.getTagName(saleType = policyType.getSaleType())))) continue;
            preferentialItem.setTag(tagName);
            preferentialItem.setCode(salePolicy.getSalePolicyCode());
            preferentialItem.setName(salePolicy.getSalePolicyName());
            preferentialItem.setValidStartTime(salePolicy.getValidStartTime());
            preferentialItem.setValidEndTime(salePolicy.getValidEndTime());
            preferentialItem.setDescription(salePolicy.getDescription());
            salePolicyProducts.stream().filter(item -> productSpecificationCodes.contains(item.getProductSpecificationCode())).forEach(item -> {
                String productSpecificationCode = item.getProductSpecificationCode();
                Set preferentialItems = (Set)specificationCodeMapping.get(productSpecificationCode);
                if (!CollectionUtils.isEmpty((Collection)preferentialItems)) {
                    preferentialItems.add(preferentialItem);
                } else {
                    preferentialItems = Sets.newHashSet();
                    preferentialItems.add(preferentialItem);
                }
                specificationCodeMapping.put(productSpecificationCode, preferentialItems);
            });
        }
        return specificationCodeMapping;
    }

    private String getTagName(Integer targ) {
        switch (targ) {
            case 1: {
                return "\u7279\u4ef7";
            }
            case 2: {
                return "\u6ee1\u6298";
            }
            case 3: {
                return "\u6ee1\u51cf";
            }
            case 4: {
                return "\u6ee1\u8d60";
            }
            case 5: {
                return "\u4e70\u8d60";
            }
        }
        return "";
    }
}

