/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.controller;

import com.bizunited.empower.business.policy.service.RebatePolicyExecuteService;
import com.bizunited.empower.business.policy.service.rebatepolicy.RebatePolicyExecuteContext;
import com.bizunited.empower.business.policy.service.rebatepolicy.context.BillCon;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/rebatePolicyExecutes"})
public class RebatePolicyExecuteController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(RebatePolicyExecuteController.class);
    @Autowired
    private RebatePolicyExecuteService rebatePolicyExecuteService;

    @PostMapping(value={"/preExecute"})
    public ResponseModel preExecute(@RequestBody @ApiParam(name="billCon", value="\u672c\u6b21\u8981\u6307\u5b9a\u8fd4\u5229\u653f\u7b56\u7684\u5355\u636e\u57fa\u672c\u4fe1\u606f") BillCon bill) {
        try {
            String tenantCode = TenantUtils.getTenantCode();
            RebatePolicyExecuteContext context = this.rebatePolicyExecuteService.preExecutePolicy(bill, tenantCode);
            return this.buildHttpResult(context);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PostMapping(value={"/execute"})
    public ResponseModel execute(@RequestBody @ApiParam(name="billCon", value="\u672c\u6b21\u8981\u6307\u5b9a\u8fd4\u5229\u653f\u7b56\u7684\u5355\u636e\u57fa\u672c\u4fe1\u606f") BillCon bill) {
        try {
            String tenantCode = TenantUtils.getTenantCode();
            RebatePolicyExecuteContext context = this.rebatePolicyExecuteService.executePolicy(bill, tenantCode);
            return this.buildHttpResult(context);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

