/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.controller;

import com.bizunited.empower.business.policy.service.RebatePolicyVoService;
import com.bizunited.empower.business.policy.vo.RebatePolicyVo;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Sets;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/rebatePolicys"})
public class RebatePolicyVoController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(RebatePolicyVoController.class);
    @Autowired
    private RebatePolicyVoService rebatePolicyVoService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @ApiOperation(value="\u6309\u7167RebatePolicys\u5b9e\u4f53\u4e2d\u7684\uff08salePolicyCode\uff09\u4fc3\u9500\u7f16\u7801\u8fdb\u884c\u67e5\u8be2")
    @RequestMapping(value={"/findDetailsByRebatePolicysCode"}, method={RequestMethod.GET})
    public ResponseModel findDetailsByRebatePolicysCode(@RequestParam(value="rebatePolicyCode") @ApiParam(value="\u4fc3\u9500\u7f16\u7801") String rebatePolicyCode) {
        try {
            RebatePolicyVo result = this.rebatePolicyVoService.findDetailsByCode(rebatePolicyCode);
            return this.buildHttpResultW((Object)result, new String[]{"products", "customers", "customers.customerLevel", "customers.customerCategory", "customers.salesArea"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u548c\u6307\u5b9a\u5ba2\u6237\u5339\u914d\u7684\u8fd4\u5229\u653f\u7b56\u4fe1\u606f\uff0c\u8fd9\u4e9b\u8fd4\u5229\u653f\u7b56\u4fe1\u606f\u90fd\u662f\u6b63\u5728\u8fdb\u884c\u4e2d\u7684\uff0c\u6ce8\u610f\uff0c\u8fd9\u91cc\u53ea\u8fd4\u56de\u57fa\u672c\u4fe1\u606f")
    @RequestMapping(value={"/findByEffectiveAndCustomerCode"}, method={RequestMethod.GET})
    public ResponseModel findByEffectiveAndCustomerCode(@RequestParam(value="customerCode") @ApiParam(value="\u6307\u5b9a\u7684\u5ba2\u6237\u4e1a\u52a1\u7f16\u53f7") String customerCode) {
        try {
            String tenantCode = TenantUtils.getTenantCode();
            LinkedHashSet rebatePolicys = this.rebatePolicyVoService.findDetailsByEffectiveAndCustomerCode(tenantCode, true, customerCode);
            if (CollectionUtils.isEmpty(rebatePolicys)) {
                return this.buildHttpResultW(rebatePolicys, new String[0]);
            }
            rebatePolicys = Sets.newLinkedHashSet((Iterable)this.nebulaToolkitService.copyCollectionByBlankList(rebatePolicys, RebatePolicyVo.class, RebatePolicyVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            return this.buildHttpResultW(rebatePolicys, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

