/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.policy.repository;

import com.bizunited.empower.business.policy.entity.RebateAccountCommonDetails;
import com.bizunited.empower.business.policy.repository.internal.RebateAccountCommonDetailsRepositoryCustom;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository(value="_RebateAccountCommonDetailsRepository")
public interface RebateAccountCommonDetailsRepository
extends RebateAccountCommonDetailsRepositoryCustom,
JpaRepository<RebateAccountCommonDetails, String>,
JpaSpecificationExecutor<RebateAccountCommonDetails> {
    @Query(value="select distinct rebateAccountCommonDetails from RebateAccountCommonDetails rebateAccountCommonDetails  left join fetch rebateAccountCommonDetails.rebateAccount rebateAccountCommonDetails_rebateAccount  where rebateAccountCommonDetails_rebateAccount.id = :id")
    public Set<RebateAccountCommonDetails> findDetailsByRebateAccount(@Param(value="id") String var1);

    @Query(value="select distinct rebateAccountCommonDetails from RebateAccountCommonDetails rebateAccountCommonDetails  left join fetch rebateAccountCommonDetails.rebateAccount rebateAccountCommonDetails_rebateAccount  where rebateAccountCommonDetails.id=:id ")
    public RebateAccountCommonDetails findDetailsById(@Param(value="id") String var1);

    @Query(value="select rebate_account_common_details.available_amount from rebate_account_common_details where rebate_account_id = :rebateAccountId AND rebate_account_common_code = (select max(rebate_account_common_code) from rebate_account_common_details where rebate_account_id = :rebateAccountId)", nativeQuery=true)
    public BigDecimal findAvailableAmountByRebateAccountId(@Param(value="rebateAccountId") String var1);

    @Query(value="from RebateAccountCommonDetails ra where ra.relevanceCode = :relevanceCode order by ra.rebateAccountCommonCode ")
    public Set<RebateAccountCommonDetails> findByRelevanceCode(@Param(value="relevanceCode") String var1);

    @Query(value="select target1.rebate_account_id , target1.available_amount , IFNULL(target2.used_amount,0)  as used_amount from    (select rac.rebate_account_id , rac.available_amount    from rebate_account_common_details rac      where rac.rebate_account_id = :rebateAccountId     and rebate_account_common_code in        (select max(rebate_account_common_code)          from rebate_account_common_details ra          where ra.rebate_account_id = :rebateAccountId)     ) as target1   left join    (select d.rebate_account_id , sum(d.detail_amount)  as used_amount      from rebate_account_common_details d       where d.rebate_account_id = :rebateAccountId and d.detail_type < 0     ) as target2  on target1.rebate_account_id = target2.rebate_account_id", nativeQuery=true)
    public Object[][] findByGroupRebateAccountId(@Param(value="rebateAccountId") String var1);

    @Modifying
    @Query(value="insert into rebate_account_common_details(id , rebate_account_common_code , available_amount , detail_amount ,detail_type , relevance_code , remark , rebate_account_id , create_account , create_time , modify_account , modify_time)  select :id,:rebateAccountCommonCode, (IFNULL(rebate_account_common_details.available_amount,0) + :detailAmount) as available_amount , :detailAmount , :detailType, :relevanceCode , :remark, :rebateAccountId , :createAccount , :createTime , :modifyAccount , :modifyTime from rebate_account_common_details WHERE rebate_account_common_details.rebate_account_id = :rebateAccountId AND rebate_account_common_details.rebate_account_common_code =  (select max(rebate_account_common_code) from rebate_account_common_details where rebate_account_common_details.rebate_account_id = :rebateAccountId)", nativeQuery=true)
    public int createForIncrement(@Param(value="id") String var1, @Param(value="rebateAccountCommonCode") String var2, @Param(value="detailAmount") BigDecimal var3, @Param(value="detailType") Integer var4, @Param(value="relevanceCode") String var5, @Param(value="rebateAccountId") String var6, @Param(value="createAccount") String var7, @Param(value="createTime") Date var8, @Param(value="modifyAccount") String var9, @Param(value="modifyTime") Date var10, @Param(value="remark") String var11);

    @Modifying
    @Query(value="insert into rebate_account_common_details(id , rebate_account_common_code , available_amount , detail_amount ,detail_type , relevance_code , remark , rebate_account_id , create_account , create_time , modify_account , modify_time)  select :id,:rebateAccountCommonCode, (IFNULL(rebate_account_common_details.available_amount,0) - :detailAmount) as available_amount , :detailAmount , :detailType, :relevanceCode , :remark, :rebateAccountId , :createAccount , :createTime , :modifyAccount , :modifyTime from rebate_account_common_details WHERE rebate_account_common_details.rebate_account_id = :rebateAccountId AND rebate_account_common_details.rebate_account_common_code =  (select max(rebate_account_common_code) from rebate_account_common_details where rebate_account_common_details.rebate_account_id = :rebateAccountId)", nativeQuery=true)
    public int createForDecrement(@Param(value="id") String var1, @Param(value="rebateAccountCommonCode") String var2, @Param(value="detailAmount") BigDecimal var3, @Param(value="detailType") Integer var4, @Param(value="relevanceCode") String var5, @Param(value="rebateAccountId") String var6, @Param(value="createAccount") String var7, @Param(value="createTime") Date var8, @Param(value="modifyAccount") String var9, @Param(value="modifyTime") Date var10, @Param(value="remark") String var11);

    @Modifying
    @Query(value="update rebate_account_common_details set relevance_code = :targetRelevanceCode where relevance_code = :sourceRelevanceCode", nativeQuery=true)
    public void updateRelevanceCode(@Param(value="sourceRelevanceCode") String var1, @Param(value="targetRelevanceCode") String var2);
}

